/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#include <stdio.h>
#include <stream.h>
#include "aum.h"
#include "aum/protocolid.h"
#include "aum/string.h"
#include "aum/msgobj.h"
#include "builtin/extern.h"

extern unsigned char *jis_to_euc (const unsigned char *from);

static Word
get_name_aux (Word x)
{
    const ProtocolID pid = MessageObject_ptr (x)->GetMessage ()->PID ();
    Word z;
    char buf[BUFSIZ];

    switch (pid.Type ()) {
    case PT_Fixnum:
	sprintf (buf, "%d", Fix2Int (pid.asWord ()));
	z = CreateASCIIString (buf);
	break;
    case PT_Atom:
	sprintf (buf, "%s", AtomPrintname (pid.asWord ()));
	z = CreateASCIIString (buf);
	break;
    case PT_Compound:
	{
	    u_char *pidname = jis_to_euc ((unsigned char *) pid.Name ());
	    int	    jst = jstrlen (pidname);
	    int	    ast = strlen ((char *) pidname);
	    if (jst != ast)
		z = CreateEUCString (pidname);
	    else
		z = CreateASCIIString ((char *) pidname);
	}
	break;
    default:
	z = SINKOBJ;
	abort ();
    }
    return z;
}

Word
doGetName (Word ax)
    // {} @ METHOD BEGIN
    // {} @ CLASS message
    // {} @ NOTATION X:get_name(^Y)
    // {} @ EXPLANATION
    // XΥå̾ʸȤȥ꡼Y³롥
    // {} @ METHOD END
{
    Word x = Dereference (ax);
    Word z;
    if (IsObject (x)) {
	switch (Pointer (x)->oTag ()) {
	case MESSAGE_OBJ:
	    z = get_name_aux (x);
	    break;

	case JOINT:
	case OBJECT:
	case IMPORTED_OBJECT:
	    z = SendBuiltinMessage1 (x, PID_GET_NAME);
	    break;

	case WC_MESSAGE_OBJ:
	    z = MessageObject_ptr (x)->Suspended_by_elt_index (PID_GET_NAME);
	    break;

	default:
	    goto error_occurred;
	}
    }
    else if (IsSink (x)) {
	z = SINKOBJ;
    }
    else {
	error_occurred:
	error (form ("%s :get_name(^M)", print (x)),
	       CAN_NOT_FIND_METHOD,"get_name/-");
	return INT0;
    }
    return z;
}

METHOD (get_name, R2_OP)
    // {}
    // get_name Ri, Rj
    // {}
    // [	   address ]
    // [  Ri|  Rj|  00|	 00]
    // {}
    // å Ri ̾ʸȤơRj ˥åȤ롥
    // {}
{
    Fetch4 ();
    Word    x = Reg[ip->b0];
    Reg[ip->b1] = doGetName (x);
    doClose (x);
    JumpNextInstruction ();
}
/*-----------------
* Local Variables:
* c-indent-level:4
* c-continued-statement-offset:4
* c-brace-offset:0
* c-imaginary-offset:0
* c-argdecl-indent:4
* c-label-offset:-4
* c++-electric-colon:t
* c++-empty-arglist-indent:nil
* c++-friend-offset:-4
* c++-member-init-indent-offset:0
* c++-continued-member-init-offset:nil
* End:
*/
