/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#include <stream.h>
#include "aum.h"
#include "aum/protocolid.h"
#include "aum/string.h"
#include "aum/msgobj.h"
#include "builtin/extern.h"

static Word
get_mode_aux (Word x)
{
    const ProtocolID pid = MessageObject_ptr (x)->GetMessage ()->PID ();
    if (pid.Type () == PT_Compound) {
	char	buf[BUFSIZ];
	char   *work;
	work = buf;
	work = sprint_protocol_mode (work, pid.Arity (), pid.Mode_mask ());
	*work = '\0';
	return CreateASCIIString (buf);
    }
    return CreateASCIIString ("0");
}

Word
doGetMode (Word ax)
    // {} @ METHOD BEGIN
    // {} @ CLASS message
    // {} @ NOTATION X:get_mode(^Y)
    // {} @ EXPLANATION
    // XγǤɽʸȥ꡼Y³롥
    // Ϥ줾ʸ@samp{-}, @samp{+} ˤäɽ롥
    // {} @ METHOD END
{
    Word x = Dereference (ax);
    Word z;
    if (IsObject (x)) {
	switch (Pointer (x)->oTag ()) {
	case MESSAGE_OBJ:
	    z = get_mode_aux (x);
	    break;

	case JOINT:
	case OBJECT:
	case IMPORTED_OBJECT:
	    z = SendBuiltinMessage1 (x, PID_GET_MODE);
	    break;

	case WC_MESSAGE_OBJ:
	    z = MessageObject_ptr (x)->Suspended_by_elt_index (PID_GET_MODE);
	    break;

	default:
	    goto error_occurred;
	}
    }
    else if (IsSink (x)) {
	z = SINKOBJ;
    }
    else {
	error_occurred:
	error (form ("%s :get_mode(^M)", print (x)),
	       CAN_NOT_FIND_METHOD,"get_mode/-");
	return INT0;
    }
    return z;
}

METHOD (get_mode, R2_OP)
    // {}
    // get_mode Ri, Rj
    // {}
    // [	   address ]
    // [  Ri|  Rj|  00|	 00]
    // {}
    // å Ri Υ⡼ɤʸȤơRj ˥åȤ롥
    // {}
{
    Fetch4 ();
    Word    x = Reg[ip->b0];
    Reg[ip->b1] = doGetMode (x);
    doClose (x);
    JumpNextInstruction ();
}
/*-----------------
* Local Variables:
* c-indent-level:4
* c-continued-statement-offset:4
* c-brace-offset:0
* c-imaginary-offset:0
* c-argdecl-indent:4
* c-label-offset:-4
* c++-electric-colon:t
* c++-empty-arglist-indent:nil
* c++-friend-offset:-4
* c++-member-init-indent-offset:0
* c++-continued-member-init-offset:nil
* End:
*/
