/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#include "aum/fetch.h"
#include "aum/string.h"
#include "aum/builtin.h"
#include "aum/compare.h"
#include "aum/object.h"
#include "aum/derive.h"
#include "builtin/extern.h"
#include "mathematics/ext-conv.h"

extern int CompareString (Word x, Word y);

Word
doGe_with_dfloat (Word ax, Word ay)
    // {}
    // ư x ȥ֥ y Ӥx 
    // 򡤤Ǥʤϵ֤⤷y ΰ褬ꤷƤʤ
    // 뤤ϥ桼֥Ȥλϥå롥
    // {}
{
    Word    y = Dereference (ay);
    if (IsDFloat (y))
	return DFloat_Ge_p (ax, y);
    if (IsFixnum (y))
	return DFloat_Ge_p (ax, Fix2Double (y));
    if (IsSFloat (y))
	return DFloat_Ge_p (ax, Single2Double (y));
    if (IsJoint (y) || IsUserObject (y))
	return SendBuiltinMessage2 (y, PID_REV_GE_DFLOAT, ax);
    if (IsImported (y))
	return CallAUmProgram (CreateSuperDoubleObject, PID_GE, ax, y);
    return BOOLFALSE;
}

Word
doGe_with_fixnum (Word ax, Word ay)
    // {}
    //  x ȥ֥ y Ӥx Ͽ򡤤Ǥ
    // ϵ֤⤷y ΰ褬ꤷƤʤ뤤ϥ桼
    // ֥Ȥλϥå롥
    // {}
{
    Word    y = Dereference (ay);
    if (IsFixnum (y))
	return Fixnum_Ge_p (ax, y);
    if (IsDFloat (y))
	return DFloat_Ge_p (Fix2Double (ax), y);
    if (IsSFloat (y))
	return SFloat_Ge_p (Fix2Single (ax), y);
    if (IsUndefined (y) || IsUserObject (y))
	return SendBuiltinMessage2 (y, PID_REV_GE_FIXNUM, ax);
    return BOOLFALSE;
}

Word
doGe_with_sfloat (Word ax, Word ay)
    // {}
    // ñư x ȥ֥ y Ӥx 
    // 򡤤Ǥʤϵ֤⤷y ΰ褬ꤷƤʤ
    // 뤤ϥ桼֥Ȥλϥå롥
    // {}
{
    Word    y = Dereference (ay);
    if (IsDFloat (y))
	return DFloat_Ge_p (Single2Double (ax), y);
    if (IsFixnum (y))
	return SFloat_Ge_p (ax, Fix2Single (y));
    if (IsSFloat (y))
	return SFloat_Ge_p (ax, y);
    if (IsUndefined (y) || IsUserObject (y))
	return SendBuiltinMessage2 (y, PID_REV_GE_SFLOAT, ax);
    return BOOLFALSE;
}

Word
doGe_with_atom (Word ax, Word ay)
    // {}
    // ȥ४֥ x ȥ֥ yӤȤϿ
    // ǤʤȤϡ֤⤷y ΰ褬ꤷƤʤС
    // å롥
    // {}
{
    Word    y = Dereference (ay);
    if (IsAtom (y))
	return (CompareAtom (ax, y) >= 0) ? BOOLTRUE : BOOLFALSE;
    if (IsUndefined (y) || IsUserObject (y))
	return SendBuiltinMessage2 (y, PID_REV_GE_ATOM, ax);
    return BOOLFALSE;
}

Word
doGe_with_string (Word ax, Word ay)
    // {}
    // ʸ x ȥ֥ y Ӥx 
    // 򡤤Ǥʤϵ֤⤷y ΰ褬ꤷƤʤ
    // 뤤ϥ桼֥Ȥλϥå롥
    // {}
{
    Word    y = Dereference (ay);
    if (IsASCII_StrObject (y) || IsEUC_StrObject (y))
	return CompareString (ax, y) >= 0 ? BOOLTRUE : BOOLFALSE;
    if (IsJoint (y) || IsUserObject (y))
	return SendBuiltinMessage2 (y, PID_REV_GE_STRING, ax);
    if (IsImported (y))
	return CallAUmProgram (CreateSuperStringObject, PID_GE, ax, y);
    return BOOLFALSE;
}

Word
doGe (Word ax, Word ay)
    // {} @ METHOD BEGIN
    // {} @ CLASS compare
    // {} @ NOTATION X:ge(Y,^Z)
    // {} @ MACRO X >= Y = ^Z
    // {} @ MACRO Y <  X = ^Z
    // {} @ EXPLANATION
    // XYӤXY礭ޤʤ@code{`true} 
    // Ǥʤˤ @code{`false} 򥹥ȥ꡼Z³롥
    // @send_when_cant_execute{Y}{ge(X,^Z)}
    // {} @ METHOD END
{
    Word    x = ax;
    Word    z;
retry:
    switch (Type_of (x)) {
    case AUm_Atom:
	z = doGe_with_atom (x, ay);
	break;
    case AUm_Fixnum:
	z = doGe_with_fixnum (x, ay);
	break;
    default:
	if (IsSFloat (x))
	    z = doGe_with_sfloat (x, ay);
	else if (IsSink (x))
	    z = SINKOBJ;
	else {
	    error (form ("%s:ge(%s,^Z)", print (ax), print (ay)),
		   CAN_NOT_FIND_METHOD,"ge/+-");
		   //errmsg_undefined_method (ax));
	    return SINKOBJ;
	}
	break;
    case AUm_Object:
	switch (Pointer (x)->Type ()) {
	case CONNECTED:
	    x = J_C_ptr (x)->Destination ();
	    goto retry;
	case JOINT:
	case OBJECT:
	case IMPORTED_OBJECT:
	    z = SendBuiltinMessage2 (x, PID_GE, ay);
	    break;
	case ASCII_STR:
	case EUC_STR:
	    z = doGe_with_string (x, ay);
	    break;
	case DFLOAT:
	    z = doGe_with_dfloat (x, ay);
	    break;
	case WC_ASCII_STR:
	    z = ASCII_StrObject_ptr (x)->Suspended_by_elt_index (PID_GE, ay);
	    break;
	case WC_EUC_STR:
	    z = EUC_StrObject_ptr (x)->Suspended_by_elt_index (PID_GE, ay);
	    break;
	default:
	    error (form ("%s:ge(%s,^Z)", print (ax), print (ay)),
		   CAN_NOT_FIND_METHOD,"ge/+-");
	    //errmsg_undefined_method (ax));
	    return SINKOBJ;
	    break;
	}
    }
    doClose (ay);
    return z;
}

METHOD (ge, R3_OP)
    // {}
    // ge Ri, Rj, Rk
    // {}
    // [	   address ]
    // [  Ri|  Rj|  Rk|	  0]
    // {}
    // Ri  Rj ꤷƤ顤 Ri  Rj Ӥ롥 Ri
    // 礭ˤϤϥ٥ L1 ʬǤʤϥ٥ L2 
    // ʬ롥 Ri  Rj Τɤ餫ꤷƤʤϤޤϥ桼
    // ֥Ȥλˤϲ⤷ʤ
    // {}
{
    Fetch4 ();
    Word    x = Reg[ip->b0];
    Reg[ip->b2] = doGe (x, Reg[ip->b1]);
    doClose (x);
    JumpNextInstruction ();
}

Word
doRevGe_atom (Word ay, Word ax)
    // {}
    // ȥ४֥ x ȥ֥ yӤȤϿ
    // ǤʤȤϡ֤⤷y ΰ褬ꤷƤʤС
    // å롥
    // {}
{
    Word    y = Dereference (ay);
    if (IsAtom (y))
	return (CompareAtom (ax, y) >= 0) ? BOOLTRUE : BOOLFALSE;
    return BOOLFALSE;
}

Word
doRevGe_string (Word ay, Word ax)
    // {}
    // ؿ doGe(Word, Word) ǰդˤƥåä
    // ν򤹤롥x ϡʸ٤Ǥ뤳ȤʬäƤ롥
    // {}
{
    Word    y = Dereference (ay);
    if (IsString (ax))
	return doGe_with_string (ax, y);
    return CallAUmProgram (CreateSuperStringObject, PID_REV_GE_STRING, y, ax);
}

Word
doRevGe_fixnum (Word ay, Word ax)
    // {}
    // ؿ doGe(Word, Word) ǰդˤƥåä
    // ν򤹤롥x ϡ٤Ǥ뤳ȤʬäƤ롥
    // {}
{
    Word    y = Dereference (ay);
    if (IsFixnum (y))
	return Fixnum_Ge_p (ax, y);
    if (IsDFloat (y))
	return DFloat_Ge_p (Fix2Double (ax), y);
    if (IsSFloat (y))
	return SFloat_Ge_p (Fix2Single (ax), y);
    return BOOLFALSE;
}

Word
doRevGe_sfloat (Word ay, Word ax)
    // {}
    // ؿ doGe(Word, Word) ǰդˤƥåä
    // ν򤹤롥x ϡñư٤Ǥ뤳ȤʬäƤ
    // 롥
    // {}
{
    Word    y = Dereference (ay);
    if (IsDFloat (y))
	return DFloat_Ge_p (Single2Double (ax), y);
    if (IsSFloat (y))
	return SFloat_Ge_p (ax, y);
    if (IsFixnum (y))
	return SFloat_Ge_p (ax, Fix2Single (y));
    return BOOLFALSE;
}

Word
doRevGe_dfloat (Word ay, Word ax)
    // {}
    // ؿ doGe(Word, Word) ǰդˤƥåä
    // ν򤹤롥x ϡư٤Ǥ뤳ȤʬäƤ
    // 롥
    // {}
{
    Word    y = Dereference (ay);
    if (IsDFloat (y))
	return DFloat_Ge_p (ax, y);
    if (IsFixnum (y))
	return DFloat_Ge_p (ax, Fix2Double (y));
    if (IsSFloat (y))
	return DFloat_Ge_p (ax, Single2Double (y));
    return BOOLFALSE;
}

/*-----------------
* Local Variables:
* c-indent-level:4
* c-continued-statement-offset:4
* c-brace-offset:0
* c-imaginary-offset:0
* c-argdecl-indent:4
* c-label-offset:-4
* c++-electric-colon:t
* c++-empty-arglist-indent:nil
* c++-friend-offset:-4
* c++-member-init-indent-offset:0
* c++-continued-member-init-offset:nil
* End:
*/
