/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#include "aum/builtin.h"
#include "aum/tstream.h"
#include "aum/alloc.h"
#include "utils/utils.h"

// Υեˤϡե󡦥֥Ȥ˴ؤ桼ƥƥ
// ᤿


void
ForeignObject::Initialize (int *a, const char *n)
    // {}
    // ե󡦥֥Ȥ롥
    // {}
{
    Header::Initialize (FOREIGN_OBJ, 1);
    address = a;
    object_name = SaveString (n);
}

void
ForeignObject::Free ()
    // {}
    // ե󡦥֥Ȥΰ롥
    // {}
{
    CancellString ((char *) object_name);
    SHARED_FREE (this, sizeof (ForeignObject));
}

Name
ForeignObject::Print ()
    // {}
    // ե󡦥֥Ȥΰ᡼ʸȤ֤
    // {}
{
    char    buff[BUFSIZ];
    tstream tout = tstream (BUFSIZ, buff);
    tout.form ("%s:0x%x", object_name, address);
    return tout.Result ();
}

ForeignObject *
new_Foreign ()
{
    return (ForeignObject *) SHARED_ALLOC (sizeof (ForeignObject));
}

Word
CreateForeignObject (int* address, const char* name)
{
    ForeignObject *fp = new_Foreign ();
    fp->Initialize (address, name);
    return ObjectWord (fp);
}

int
CompareForeign (Word x, Word y)
    // {}
    // ե󡦥֥ȤӤ򤹤롥
    // {}
{
    ForeignObject *fx = (ForeignObject *) Object_ptr (x);
    ForeignObject *fy = (ForeignObject *) Object_ptr (y);
    int	    result = strcmp (fx->ObjectName (), fy->ObjectName ());
    if (result != 0)
	return result;
    return fx->Address () - fy->Address ();
}

/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-brace-offset:0
 * c-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-electric-colon:t
 * c++-empty-arglist-indent:nil
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */
