/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#include "aum/fetch.h"
#include "aum/builtin.h"
#include "builtin/extern.h"

Word
doFalse_p (Word ay)
    // {}
    // ֥ y ֡ꥢ󡦥֥Ȥʤ not y ֤y
    // ηޤäƤʤ祤Ȥξ硤뤤ϥ桼֥
    // Ȥξˤϥå롥
    // {}
{
    Word y = Dereference (ay);
    if (IsTrue (y))
	return BOOLFALSE;
    if (IsFalse (y))
	return BOOLTRUE;
    return SendBuiltinMessage1 (y, PID_REV_FALSE);
}

Word
doRevFalse (Word ay)
    // {}
    // ؿ doFalse/2 ǰդˤƥåäν򤹤롥
    // {}
{
    Word y = Dereference (ay);
    if (IsTrue (y))
	return BOOLFALSE;
    if (IsFalse (y))
	return BOOLTRUE;
    return boolean_error ("reverse false", ay);
}

/*-----------------
* Local Variables:
* c-indent-level:4
* c-continued-statement-offset:4
* c-brace-offset:0
* c-imaginary-offset:0
* c-argdecl-indent:4
* c-label-offset:-4
* c++-electric-colon:t
* c++-empty-arglist-indent:nil
* c++-friend-offset:-4
* c++-member-init-indent-offset:0
* c++-continued-member-init-offset:nil
* End:
*/
