/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#ifndef builtin_extern_h
#define builtin_extern_h

#include "aum/stdlib.h"
#include "aum/close.h"
#include "aum/message.h"
#include "aum/execbmsg.h"
#include "aum/merger.h"
#include "aum/alloc.h"
#include "aum/connect.h"
#include "table/atomhash.h"
#include "table/protocol.h"
#include "mathematics/conv.h"


extern void trace (const char *fmt);
extern Word SendBuiltinMessage1 (Word, const ProtocolID);
extern Word SendBuiltinMessage2 (Word, const ProtocolID, Word);
extern Word SendBuiltinMessage3 (Word, const ProtocolID, Word, Word);
extern void trace (const char *fm);
extern int GetListLength (Word & x);
extern Word CreateDFloat (double x);
extern Word CopyList (Word & x);
extern Word CopyASCIIString (Word x);
extern Word CopyEUCString (Word x);

extern Word doTrue_p (Word y);
extern Word doFalse_p (Word y);
extern Word CreateClass (ClassTmpl * ct);
extern Word CopyString (Word & x);
extern Word CopyObject (Word & x);
extern Word CreateString (Name &);

extern Word CreateList (ObjectTag tag, Word car, Word cdr);
//
extern Word boolean_error (const char *, Word);
extern Word boolean_error (const char *, Word, Word);

// File IO
extern Word doOpen (Word, Word);
extern Word doRevOpen (Word, Word);
extern Word doGet (Word);
extern Word doGetc (Word);
extern Word doGets (Word);

//
extern Boolean Subseq_valid_position (Word, int, int, int);
extern ProtocolID SearchProtocolID (Word atom, u_char arity, u_long modes);
extern Boolean IsInstantiated (Word & x);

inline	Word
doConnectInlet (Word x, Word y)
    // {}
    // ֥ x ü祤 y ³롥
    // {}
{
    doConnect (x, (J_NC_t *) Pointer (y));
    return x;
}

inline int
IsNotConnectedJoint (Word x)
    // {}
    // ֥ x DEREFERENCEоݥ祤Ȥʤ顡1
    // Ǥʤ 0 ֤
    // {}
{
    if (Type_of (x) != AUm_Object)
	return 0;
    switch (ObjectType (x)) {
    case MJ_C:
    case AJ_C:
    case MJ_Mut:
	return 1;
    default:
	break;
    }
    return 0;
}

inline int
IsConnectedJoint (Word x)
    // {}
    // ֥ x ηޤäƤʤ祤Ȥʤ顡1
    // Ǥʤ 0 ֤
    // {}
{
    switch (Type_of (x)) {
    case AUm_Object:
	switch (ObjectType (x)) {
	case MJ_NC:
	case AJ_NC:
	case MJ_W:
	case IMP_OBJ:
	case IMP_OBJ_NT:
	case IMP_INLET:
	case IMP_OUTLET:
	    return 1;
	default:
	    break;
	}
    default:
	break;
    }
    return 0;
}

inline	Word
ToConnectedJoint (Word x)
{
    while (IsObject (x)) {
	switch (ObjectType (x)) {
	case MJ_C:
	case AJ_C:
	case MJ_Mut:
	    x = J_C_ptr (x)->Destination ();
	    continue;
	default:
	    return x;
	}
    }
    return x;
}

#define SPACE  0xa1a1
#define PLUS   0xa1dc
#define MINUS  0xa1dd
#define ZERO   0xa3b0
#define NINE   0xa3b9
#define LBASE  0xa3c5
#define SBASE  0xa3e5
#define POINT  0xa1a5

enum {
    ALARGE = 0xa3c1, ASMALL = 0xa3e1,
    BLARGE = ALARGE + 1, BSMALL = ASMALL + 1,
    CLARGE = ALARGE + 2, CSMALL = ASMALL + 2,
    DLARGE = ALARGE + 3, DSMALL = ASMALL + 3,
    ELARGE = ALARGE + 4, ESMALL = ASMALL + 4,
    FLARGE = ALARGE + 5, FSMALL = ASMALL + 5,
    GLARGE = ALARGE + 6, GSMALL = ASMALL + 6,
    HLARGE = ALARGE + 7, HSMALL = ASMALL + 7,
    ILARGE = ALARGE + 8, ISMALL = ASMALL + 8,
    JLARGE = ALARGE + 9, JSMALL = ASMALL + 9,
    KLARGE = ALARGE + 10, KSMALL = ASMALL + 10,
    LLARGE = ALARGE + 11, LSMALL = ASMALL + 11,
    DMARGE = ALARGE + 12, MSMALL = ASMALL + 12,
    NLARGE = ALARGE + 13, NSMALL = ASMALL + 13,
    OLARGE = ALARGE + 14, OSMALL = ASMALL + 14,
    PLARGE = ALARGE + 15, PSMALL = ASMALL + 15,
    QLARGE = ALARGE + 16, QSMALL = ASMALL + 16,
    RLARGE = ALARGE + 17, RSMALL = ASMALL + 17,
    SLARGE = ALARGE + 18, SSMALL = ASMALL + 18,
    TLARGE = ALARGE + 19, TSMALL = ASMALL + 19,
    ULARGE = ALARGE + 20, USMALL = ASMALL + 20,
    VLARGE = ALARGE + 21, VSMALL = ASMALL + 21,
    WLARGE = ALARGE + 22, WSMALL = ASMALL + 22,
    XLARGE = ALARGE + 23, XSMALL = ASMALL + 23,
    YLARGE = ALARGE + 24, YSMALL = ASMALL + 24,
    ZLARGE = ALARGE + 25, ZSMALL = ASMALL + 25
};

/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-brace-offset:0
 * c-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-electric-colon:t
 * c++-empty-arglist-indent:nil
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */
#endif builtin_extern_h
