/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#include <stdlib.h>
#include "mathematics/mathlib.h"
#include "builtin/extern.h"
#include "aum/global.h"
#include "aum/trace.h"

//#define _SMART_KERNEL_LIST_
#define _SMART_KERNEL_MATHLIB_

extern Word doMinus (Word);
extern Word doAdd (Word, Word);
extern Word doSub (Word, Word);
extern Word doMul (Word, Word);
extern Word doDiv (Word, Word);
extern Word doMod (Word, Word);
extern Word doShtl (Word, Word);
extern Word doShtr (Word, Word);
extern Word doNot (Word);
extern Word doAnd (Word, Word);
extern Word doOr (Word, Word);
extern Word doXor (Word, Word);
extern Word doRevTrue (Word y);
extern Word doRevFalse (Word y);
extern Word doClassof (Word);
extern Word doClass_name (Word);
extern Word doIsSimple (Word);
extern Word doIsBuiltin (Word);
extern Word doWho (Word);
extern Word doCreateVector (Word x, Word y);
extern Word doRevMod_fixnum (Word, Word);
extern Word doRevShtr_fixnum (Word, Word);
extern Word doRevShtl_fixnum (Word, Word);
extern Word doRevAdd_fixnum (Word, Word);
extern Word doRevAdd_sfloat (Word, Word);
extern Word doRevAdd_dfloat (Word, Word);
extern Word doRevSub_fixnum (Word, Word);
extern Word doRevSub_sfloat (Word, Word);
extern Word doRevSub_dfloat (Word, Word);
extern Word doRevDiv_fixnum (Word, Word);
extern Word doRevDiv_sfloat (Word, Word);
extern Word doRevDiv_dfloat (Word, Word);
extern Word doRevMul_fixnum (Word, Word);
extern Word doRevMul_sfloat (Word, Word);
extern Word doRevMul_dfloat (Word, Word);

/// EQ ///
extern Word doEq (Word, Word);
extern Word doRevEq_atom (Word y, Word x);
extern Word doRevEq_fixnum (Word, Word);
extern Word doRevEq_sfloat (Word, Word);
extern Word doRevEq_dfloat (Word, Word);
extern Word doRevEq_vector (Word, Word);
extern Word doRevEq_string (Word, Word);

/// NEQ ///
extern Word doNeq (Word, Word);
extern Word doRevNeq_atom (Word, Word);
extern Word doRevNeq_fixnum (Word, Word);
extern Word doRevNeq_sfloat (Word, Word);
extern Word doRevNeq_dfloat (Word, Word);
extern Word doRevNeq_vector (Word, Word);
extern Word doRevNeq_string (Word, Word);

/// GT ///
extern Word doGt (Word, Word);
extern Word doRevGt_atom (Word, Word);
extern Word doRevGt_fixnum (Word, Word);
extern Word doRevGt_sfloat (Word, Word);
extern Word doRevGt_dfloat (Word, Word);
extern Word doRevGt_string (Word, Word);

/// GE ///
extern Word doGe (Word, Word);
extern Word doRevGe_atom (Word, Word);
extern Word doRevGe_fixnum (Word, Word);
extern Word doRevGe_sfloat (Word, Word);
extern Word doRevGe_dfloat (Word, Word);
extern Word doRevGe_string (Word, Word);

extern Word doInstantiate (Word);
extern Word doAppend (Word x, Word y);
extern Word doRevAppendString (Word x, Word y);
extern Word doString (Word x);
extern Word doInt (Word x);
extern Word doFloat (Word x);
extern Word doDouble (Word x);
extern void doCopy (Word x, Word y);
extern Word doLength (Word x);
extern Word doGetName (Word x);
extern Word doGetMode (Word x);
extern Word doIsEof (Word x);
extern Word doGetc (Word x);
extern Word doGets (Word x);
extern Word doGet (Word x);
extern void doPutc (Word x, Word y);
extern void doRevPutc (Word x, Word y);
extern void doPuts (Word x, Word y);
extern void doRevPuts (Word x, Word y);
extern void doPut (Word x, Word y);
extern void doRevPut (Word x, Word y);

#ifndef _SMART_KERNEL_LIST_
extern Word doRevEq_list (Word, Word);
extern Word doRevNeq_list (Word, Word);
extern Word doRevAppendList (Word x, Word y);

extern Word doCaro (Word x);
extern Word doCdro (Word x);
extern Word doCari (Word x);
extern Word doCdri (Word x);
extern void doSetCari (Word x, Word y);
extern void doSetCaro (Word x, Word y);
extern void doSetCdri (Word x, Word y);
extern void doSetCdro (Word x, Word y);
#endif

extern void doSeti (Word, Word, Word);
extern void doSeto (Word, Word, Word);
extern Word doElti (Word, Word);
extern Word doElto (Word, Word);
extern Word doFix (Word x);
extern Word doDir (Word x, Word y);

extern Word doRevBitXor (Word x, Word y);
extern Word doRevBitAnd (Word x, Word y);
extern Word doRevBitOr (Word x, Word y);
extern Word doSubSeq (Word x, Word y, Word z);
extern void doUnGetc (Word x, Word y);
extern void doFflush (Word x);

extern void doFprintf (Word, Word, Word);
extern void doRevFprintf_arg1 (Word, Word, Word);
extern void doRevFprintf_arg2 (Word, Word, Word);
extern void doFscanf (Word x, Word y);

extern const MathLib1 Cos;
extern const MathLib1 Exp;
extern const MathLib1 Log;
extern const MathLib1 Dlog;
extern const MathLib1 Sin;
extern const MathLib1 Sqrt;
extern const MathLib1 Tan;

extern Word doPow (Word x, Word y);
extern Word doRevFixPow (Word x, Word y);
extern Word doRevSFloatPow (Word x, Word y);
extern Word doRevDFloatPow (Word x, Word y);

#ifndef _SMART_KERNEL_MATHLIB_
extern const MathLib1 Abs;
extern const MathLib1 Asin;
extern const MathLib1 Acos;
extern const MathLib1 Atan;
extern const MathLib1 Ceil;
extern const MathLib1 Hcos;
extern const MathLib1 Fabs;
extern const MathLib1 Floor;
extern const MathLib1 Gamma;
extern const MathLib1 Bfj0;
extern const MathLib1 Bfj1;
extern const MathLib1 Bfy0;
extern const MathLib1 Bfy1;
extern const MathLib1 Hsin;
extern const MathLib1 Htan;

extern Word doAtan2 (Word x, Word y);
extern Word doRevAtan2_fixnum (Word x, Word y);
extern Word doRevAtan2_sfloat (Word x, Word y);
extern Word doRevAtan2_double (Word x, Word y);

extern Word doCabs (Word, Word);
extern Word doRevCabs_fixnum (Word, Word);
extern Word doRevCabs_sfloat (Word, Word);
extern Word doRevCabs_dfloat (Word, Word);

extern Word doHypot (Word x, Word y);
extern Word doRevHypot_fixnum (Word y, Word x);
extern Word doRevHypot_sfloat (Word y, Word x);
extern Word doRevHypot_double (Word x, Word y);

extern Word doBfjn (Word x, Word y);
extern Word doRevBfjn (Word x, Word y);
extern Word doBfyn (Word x, Word y);
extern Word doRevBfyn (Word x, Word y);

#endif	/* eof smart mathematics */

extern Word doCreateMessage (Word x);

// {}
// void ExecuteBuiltinMessage(Word operand, Message* mp)
// {}
// ǽ:
// ϥ֥Ȥ뤤Ȥ߹ߥ֥ȤǤ operand 
// Ƥå mp ϡȤ߹̿᤬¹ԲǤΰ褬̤
// Ǥä˥åѴ줿ΤǤ롥Υå
// ϰ褬ꤷǡƤȹ̿ȤƼ¹Ԥ롥
// {}
// 
// ң稡䨢	  Σ 
// 
// 	  Уɣ     
// 
// 	   	     
// 
//
// 
// ң稡䨢	  Σ 
// 
// 	  Уɣ     
// 
// 	ڥ   
// 
// 	   	     
// 
//
// {}

void
ExecuteBuiltinMessage (Word operand, Message * mp)
    // {}
    // ȹ֥ȤؤΥå¹Ԥ롥
    // {}
{
    if (TraceMessage)
	mlog3 ("Exec", operand, mp);

    Word    dest, result = INT0;

    // operand å¹оݤΥ֥
    // ̤֤祤

    switch ((mp->PID ()).peep ()) {
    case PID_CREATE_MESSAGE:
	dest = mp->Argv (0);
	result = doCreateMessage (operand);
	break;

    case PID_INSTANTIATE:
	dest = mp->Argv (0);
	result = doInstantiate (operand);
	break;

    case PID_MINUS:
	dest = mp->Argv (0);
	result = doMinus (operand);
	break;

#ifndef _SMART_KERNEL_LIST_
    case PID_CAR_O:
	dest = mp->Argv (0);
	result = doCaro (operand);
	break;
    case PID_CDR_O:
	dest = mp->Argv (0);
	result = doCdro (operand);
	break;
    case PID_CAR_I:
	dest = doCari (operand);
	result = mp->Argv (0);
	break;
    case PID_CDR_I:
	dest = doCdri (operand);
	result = mp->Argv (0);
	break;
    case PID_REV_EQ_LIST:
	dest = mp->Argv (1);
	result = doRevEq_list (operand, mp->Argv (0));
	break;
    case PID_REV_NEQ_LIST:
	dest = mp->Argv (1);
	result = doRevNeq_list (operand, mp->Argv (0));
	break;
    case PID_REV_APPEND_LIST:
	dest = mp->Argv (1);
	result = doRevAppendList (operand, mp->Argv (0));
	break;

    case PID_SETCAR_I:
	doSetCari (operand, mp->Argv (0));
	mp->Free ();
	return;

    case PID_SETCAR_O:
	doSetCaro (operand, mp->Argv (0));
	mp->Free ();
	return;

    case PID_SETCDR_I:
	doSetCdri (operand, mp->Argv (0));
	mp->Free ();
	return;

    case PID_SETCDR_O:
	doSetCdro (operand, mp->Argv (0));
	mp->Free ();
	return;

#endif

    case PID_NOT:
	dest = mp->Argv (0);
	result = doNot (operand);
	break;

    case PID_REV_TRUE:
	dest = mp->Argv (0);
	result = doRevTrue (operand);
	break;

    case PID_REV_FALSE:
	dest = mp->Argv (0);
	result = doRevFalse (operand);
	break;

    case PID_CLASSOF:
	dest = mp->Argv (0);
	result = doClassof (operand);
	break;

    case PID_CLASS_NAME:
	dest = mp->Argv (0);
	result = doClass_name (operand);
	break;

    case PID_ISSIMPLE:
	dest = mp->Argv (0);
	result = doIsSimple (operand);
	break;

    case PID_ISBUILTIN:
	dest = mp->Argv (0);
	result = doIsBuiltin (operand);
	break;

    case PID_WHO:
	dest = doWho (operand);
	result = mp->Argv (0);
	break;

    case PID_STRING:
	dest = mp->Argv (0);
	result = doString (operand);
	break;

    case PID_INT:
	dest = mp->Argv (0);
	result = doInt (operand);
	break;

    case PID_FLOAT:
	dest = mp->Argv (0);
	result = doFloat (operand);
	break;

    case PID_DOUBLE:
	dest = mp->Argv (0);
	result = doDouble (operand);
	break;

    case PID_COPY:
	doCopy (operand, mp->Argv (0));
	mp->Free ();
	return;

    case PID_LENGTH:
	dest = mp->Argv (0);
	result = doLength (operand);
	break;

    case PID_ISEOF:
	dest = mp->Argv (0);
	result = doIsEof (operand);
	break;

    case PID_FFLUSH:
	doFflush (operand);
	mp->Free ();
	return;

    case PID_GETC:
	dest = mp->Argv (0);
	result = doGetc (operand);
	break;

    case PID_GETS:
	dest = mp->Argv (0);
	result = doGets (operand);
	break;

    case PID_GET_MODE:
	dest = mp->Argv (0);
	result = doGetMode (operand);
	break;

    case PID_GET_NAME:
	dest = mp->Argv (0);
	result = doGetName (operand);
	break;

    case PID_GET:
	dest = mp->Argv (0);
	result = doGet (operand);
	break;

    case PID_COS:
	dest = mp->Argv (0);
	result = Cos.Calculate (operand);
	break;

    case PID_EXP:
	dest = mp->Argv (0);
	result = Exp.Calculate (operand);
	break;

    case PID_LOG:
	dest = mp->Argv (0);
	result = Log.Calculate (operand);
	break;

    case PID_DLOG:
	dest = mp->Argv (0);
	result = Dlog.Calculate (operand);
	break;

    case PID_SIN:
	dest = mp->Argv (0);
	result = Sin.Calculate (operand);
	break;

    case PID_TAN:
	dest = mp->Argv (0);
	result = Tan.Calculate (operand);
	break;

    case PID_SQRT:
	dest = mp->Argv (0);
	result = Sqrt.Calculate (operand);
	break;

    case PID_POW:
	dest = mp->Argv (1);
	result = doPow (operand, mp->Argv (0));
	break;
    case PID_REV_POW_FIXNUM:
	dest = mp->Argv (1);
	result = doRevFixPow (operand, mp->Argv (0));
	break;
    case PID_REV_POW_SFLOAT:
	dest = mp->Argv (1);
	result = doRevSFloatPow (operand, mp->Argv (0));
	break;
    case PID_REV_POW_DFLOAT:
	dest = mp->Argv (1);
	result = doRevDFloatPow (operand, mp->Argv (0));
	break;

#ifndef _SMART_KERNEL_MATHLIB_
    case PID_ABS:
	dest = mp->Argv (0);
	result = Abs.Calculate (operand);
	break;

    case PID_ASIN:
	dest = mp->Argv (0);
	result = Asin.Calculate (operand);
	break;

    case PID_CEIL:
	dest = mp->Argv (0);
	result = Ceil.Calculate (operand);
	break;

    case PID_HCOS:
	dest = mp->Argv (0);
	result = Hcos.Calculate (operand);
	break;

    case PID_ACOS:
	dest = mp->Argv (0);
	result = Acos.Calculate (operand);
	break;

    case PID_FABS:
	dest = mp->Argv (0);
	result = Fabs.Calculate (operand);
	break;

    case PID_FLOOR:
	dest = mp->Argv (0);
	result = Floor.Calculate (operand);
	break;

    case PID_GAMMA:
	dest = mp->Argv (0);
	result = Gamma.Calculate (operand);
	break;

    case PID_BFJ0:
	dest = mp->Argv (0);
	result = Bfj0.Calculate (operand);
	break;

    case PID_BFJ1:
	dest = mp->Argv (0);
	result = Bfj1.Calculate (operand);
	break;

    case PID_BFY0:
	dest = mp->Argv (0);
	result = Bfy0.Calculate (operand);
	break;

    case PID_BFY1:
	dest = mp->Argv (0);
	result = Bfy1.Calculate (operand);
	break;

    case PID_HSIN:
	dest = mp->Argv (0);
	result = Hsin.Calculate (operand);
	break;

    case PID_HTAN:
	dest = mp->Argv (0);
	result = Htan.Calculate (operand);
	break;

    case PID_ATAN:
	dest = mp->Argv (0);
	result = Atan.Calculate (operand);
	break;

    case PID_BFJN:
	dest = mp->Argv (1);
	result = doBfjn (operand, mp->Argv (0));
	break;

    case PID_REV_BFJN:
	dest = mp->Argv (1);
	result = doRevBfjn (operand, mp->Argv (0));
	break;

    case PID_BFYN:
	dest = mp->Argv (1);
	result = doBfyn (operand, mp->Argv (0));
	break;

    case PID_REV_BFYN:
	dest = mp->Argv (1);
	result = doRevBfyn (operand, mp->Argv (0));
	break;

    case PID_CABS:
	dest = mp->Argv (1);
	result = doCabs (operand, mp->Argv (0));
	break;

    case PID_HYPOT:
	dest = mp->Argv (1);
	result = doHypot (operand, mp->Argv (0));
	break;

    case PID_REV_A2TAN_FIXNUM:
	dest = mp->Argv (1);
	result = doRevAtan2_fixnum (operand, mp->Argv (0));
	break;
    case PID_REV_A2TAN_SFLOAT:
	dest = mp->Argv (1);
	result = doRevAtan2_sfloat (operand, mp->Argv (0));
	break;
    case PID_REV_A2TAN_DFLOAT:
	dest = mp->Argv (1);
	result = doRevAtan2_double (operand, mp->Argv (0));
	break;
    case PID_A2TAN:
	dest = mp->Argv (1);
	result = doAtan2 (operand, mp->Argv (0));
	break;

    case PID_REV_HYPOT_FIXNUM:
	dest = mp->Argv (1);
	result = doRevHypot_fixnum (operand, mp->Argv (0));
	break;

    case PID_REV_HYPOT_SFLOAT:
	dest = mp->Argv (1);
	result = doRevHypot_sfloat (operand, mp->Argv (0));
	break;

    case PID_REV_HYPOT_DFLOAT:
	dest = mp->Argv (1);
	result = doRevHypot_double (operand, mp->Argv (0));
	break;

    case PID_REV_CABS_FIXNUM:
	dest = mp->Argv (1);
	result = doRevCabs_fixnum (operand, mp->Argv (0));
	break;

    case PID_REV_CABS_SFLOAT:
	dest = mp->Argv (1);
	result = doRevCabs_sfloat (operand, mp->Argv (0));
	break;

    case PID_REV_CABS_DFLOAT:
	dest = mp->Argv (1);
	result = doRevCabs_dfloat (operand, mp->Argv (0));
	break;

#endif /* eof smart kernel*/
    case PID_UNGETC:
	doUnGetc (operand, mp->Argv (0));
	mp->Free ();
	return;

    case PID_PUT:
	doPut (operand, mp->Argv (0));
	mp->Free ();
	return;

    case PID_REV_PUT:
	doRevPut (operand, mp->Argv (0));
	mp->Free ();
	return;

    case PID_PUTC:
	doPutc (operand, mp->Argv (0));
	mp->Free ();
	return;

    case PID_REV_PUTC:
	doRevPutc (operand, mp->Argv (0));
	mp->Free ();
	return;

    case PID_PUTS:
	doPuts (operand, mp->Argv (0));
	mp->Free ();
	return;

    case PID_REV_PUTS:
	doRevPuts (operand, mp->Argv (0));
	mp->Free ();
	return;

    case PID_ADD:
	dest = mp->Argv (1);
	result = doAdd (operand, mp->Argv (0));
	break;

    case PID_SUB:
	dest = mp->Argv (1);
	result = doSub (operand, mp->Argv (0));
	break;

    case PID_MUL:
	dest = mp->Argv (1);
	result = doMul (operand, mp->Argv (0));
	break;

    case PID_DIV:
	dest = mp->Argv (1);
	result = doDiv (operand, mp->Argv (0));
	break;

    case PID_MOD:
	dest = mp->Argv (1);
	result = doMod (operand, mp->Argv (0));
	break;

    case PID_SHTL:
	dest = mp->Argv (1);
	result = doShtl (operand, mp->Argv (0));
	break;

    case PID_SHTR:
	dest = mp->Argv (1);
	result = doShtr (operand, mp->Argv (0));
	break;

    case PID_AND:
	dest = mp->Argv (1);
	result = doAnd (operand, mp->Argv (0));
	break;

    case PID_OR:
	dest = mp->Argv (1);
	result = doOr (operand, mp->Argv (0));
	break;

    case PID_XOR:
	dest = mp->Argv (1);
	result = doXor (operand, mp->Argv (0));
	break;

	/// EQ ///
    case PID_EQ:
	dest = mp->Argv (1);
	result = doEq (operand, mp->Argv (0));
	break;
    case PID_REV_EQ_ATOM:
	dest = mp->Argv (1);
	result = doRevEq_atom (operand, mp->Argv (0));
	break;
    case PID_REV_EQ_FIXNUM:
	dest = mp->Argv (1);
	result = doRevEq_fixnum (operand, mp->Argv (0));
	break;
    case PID_REV_EQ_DFLOAT:
	dest = mp->Argv (1);
	result = doRevEq_dfloat (operand, mp->Argv (0));
	break;
    case PID_REV_EQ_SFLOAT:
	dest = mp->Argv (1);
	result = doRevEq_sfloat (operand, mp->Argv (0));
	break;
    case PID_REV_EQ_VECTOR:
	dest = mp->Argv (1);
	result = doRevEq_vector (operand, mp->Argv (0));
	break;
    case PID_REV_EQ_STRING:
	dest = mp->Argv (1);
	result = doRevEq_string (operand, mp->Argv (0));
	break;

	/// NEQ ///
    case PID_NEQ:
	dest = mp->Argv (1);
	result = doNeq (operand, mp->Argv (0));
	break;
    case PID_REV_NEQ_ATOM:
	dest = mp->Argv (1);
	result = doRevNeq_atom (operand, mp->Argv (0));
	break;
    case PID_REV_NEQ_FIXNUM:
	dest = mp->Argv (1);
	result = doRevNeq_fixnum (operand, mp->Argv (0));
	break;
    case PID_REV_NEQ_DFLOAT:
	dest = mp->Argv (1);
	result = doRevNeq_dfloat (operand, mp->Argv (0));
	break;
    case PID_REV_NEQ_SFLOAT:
	dest = mp->Argv (1);
	result = doRevNeq_sfloat (operand, mp->Argv (0));
	break;
    case PID_REV_NEQ_VECTOR:
	dest = mp->Argv (1);
	result = doRevNeq_vector (operand, mp->Argv (0));
	break;
    case PID_REV_NEQ_STRING:
	dest = mp->Argv (1);
	result = doRevNeq_string (operand, mp->Argv (0));
	break;

	/// GT ///
    case PID_GT:
	dest = mp->Argv (1);
	result = doGt (operand, mp->Argv (0));
	break;
    case PID_REV_GT_ATOM:
	dest = mp->Argv (1);
	result = doRevGt_atom (operand, mp->Argv (0));
	break;
    case PID_REV_GT_FIXNUM:
	dest = mp->Argv (1);
	result = doRevGt_fixnum (operand, mp->Argv (0));
	break;
    case PID_REV_GT_DFLOAT:
	dest = mp->Argv (1);
	result = doRevGt_dfloat (operand, mp->Argv (0));
	break;
    case PID_REV_GT_SFLOAT:
	dest = mp->Argv (1);
	result = doRevGt_sfloat (operand, mp->Argv (0));
	break;
    case PID_REV_GT_STRING:
	dest = mp->Argv (1);
	result = doRevGt_string (operand, mp->Argv (0));
	break;

	/// GE ///
    case PID_GE:
	dest = mp->Argv (1);
	result = doGe (operand, mp->Argv (0));
	break;
    case PID_REV_GE_ATOM:
	dest = mp->Argv (1);
	result = doRevGe_atom (operand, mp->Argv (0));
	break;
    case PID_REV_GE_FIXNUM:
	dest = mp->Argv (1);
	result = doRevGe_fixnum (operand, mp->Argv (0));
	break;
    case PID_REV_GE_DFLOAT:
	dest = mp->Argv (1);
	result = doRevGe_dfloat (operand, mp->Argv (0));
	break;
    case PID_REV_GE_SFLOAT:
	dest = mp->Argv (1);
	result = doRevGe_sfloat (operand, mp->Argv (0));
	break;
    case PID_REV_GE_STRING:
	dest = mp->Argv (1);
	result = doRevGe_string (operand, mp->Argv (0));
	break;

    case PID_REV_ADD_FIXNUM:
	dest = mp->Argv (1);
	result = doRevAdd_fixnum (operand, mp->Argv (0));
	break;

    case PID_REV_ADD_SFLOAT:
	dest = mp->Argv (1);
	result = doRevAdd_sfloat (operand, mp->Argv (0));
	break;

    case PID_REV_ADD_DFLOAT:
	dest = mp->Argv (1);
	result = doRevAdd_dfloat (operand, mp->Argv (0));
	break;

    case PID_REV_SUB_FIXNUM:
	dest = mp->Argv (1);
	result = doRevSub_fixnum (operand, mp->Argv (0));
	break;

    case PID_REV_SUB_SFLOAT:
	dest = mp->Argv (1);
	result = doRevSub_sfloat (operand, mp->Argv (0));
	break;

    case PID_REV_SUB_DFLOAT:
	dest = mp->Argv (1);
	result = doRevSub_dfloat (operand, mp->Argv (0));
	break;

    case PID_REV_DIV_FIXNUM:
	dest = mp->Argv (1);
	result = doRevDiv_fixnum (operand, mp->Argv (0));
	break;

    case PID_REV_DIV_SFLOAT:
	dest = mp->Argv (1);
	result = doRevDiv_sfloat (operand, mp->Argv (0));
	break;

    case PID_REV_DIV_DFLOAT:
	dest = mp->Argv (1);
	result = doRevDiv_dfloat (operand, mp->Argv (0));
	break;
    case PID_REV_MUL_FIXNUM:
	dest = mp->Argv (1);
	result = doRevMul_fixnum (operand, mp->Argv (0));
	break;

    case PID_REV_MUL_SFLOAT:
	dest = mp->Argv (1);
	result = doRevMul_sfloat (operand, mp->Argv (0));
	break;

    case PID_REV_MUL_DFLOAT:
	dest = mp->Argv (1);
	result = doRevMul_dfloat (operand, mp->Argv (0));
	break;

    case PID_REV_MOD_FIXNUM:
	result = doRevMod_fixnum (operand, mp->Argv (0));
	dest = mp->Argv (1);
	break;

    case PID_REV_SHTR_FIXNUM:
	dest = mp->Argv (1);
	result = doRevShtr_fixnum (operand, mp->Argv (0));
	break;

    case PID_REV_SHTL_FIXNUM:
	dest = mp->Argv (1);
	result = doRevShtl_fixnum (operand, mp->Argv (0));
	break;

    case PID_APPEND:
	dest = mp->Argv (1);
	result = doAppend (operand, mp->Argv (0));
	break;

    case PID_REV_APPEND_STRING:
	dest = mp->Argv (1);
	result = doRevAppendString (operand, mp->Argv (0));
	break;

    case PID_OPEN:
	dest = mp->Argv (1);
	result = doOpen (operand, mp->Argv (0));
	break;

    case PID_REV_OPEN:
	dest = mp->Argv (1);
	result = doRevOpen (operand, mp->Argv (0));
	break;

    case PID_CREATE_VECTOR:
	dest = mp->Argv (1);
	result = doCreateVector (operand, mp->Argv (0));
	break;

    case PID_REV_BIT_XOR:
	dest = mp->Argv (1);
	result = doRevBitXor (operand, mp->Argv (0));
	break;

    case PID_REV_BIT_OR:
	dest = mp->Argv (1);
	result = doRevBitOr (operand, mp->Argv (0));
	break;
    case PID_REV_BIT_AND:
	dest = mp->Argv (1);
	result = doRevBitAnd (operand, mp->Argv (0));
	break;
    case PID_FSCANF:;
	dest = mp->Argv (1);
	doFscanf (operand, mp->Argv (0));
	break;

    case PID_SET_O:
	doSeto (operand, mp->Argv (0), mp->Argv (1));
	mp->Free ();
	return;

    case PID_SET_I:
	doSeti (operand, mp->Argv (0), mp->Argv (1));
	mp->Free ();
	return;

    case PID_ELT_O:
	dest = mp->Argv (1);
	result = doElto (operand, mp->Argv (0));
	break;

    case PID_ELT_I:
	dest = doElti (operand, mp->Argv (0));
	result = mp->Argv (1);
	break;

    case PID_DIR:
	dest = mp->Argv (1);
	result = doDir (operand, mp->Argv (0));
	break;

    case PID_FIX:
	dest = doFix (operand);
	result = mp->Argv (0);
	break;

    case PID_SUBSEQ:
	dest = mp->Argv (2);
	result = doSubSeq (operand, mp->Argv (0), mp->Argv (1));
	break;

    case PID_FPRINTF:
	doFprintf (operand, mp->Argv (0), mp->Argv (1));
	mp->Free ();
	return;

    case PID_REV_FPRINTF_ARG1:
	doRevFprintf_arg1 (operand, mp->Argv (0), mp->Argv (1));
	mp->Free ();
	return;

    case PID_REV_FPRINTF_ARG2:
	doRevFprintf_arg2 (operand, mp->Argv (0), mp->Argv (1));
	mp->Free ();
	return;

    default:
	if (IsSink (operand)) {
	    mp->Terminate ();
	} else if (IsErrorObject (operand)) {
	    if (Warnning) {
		warn ("Execute builtin message",
		      "message \"%s\" is sent to Error Object",
		      mp->Print ());
	    }
	    mp->Terminate ();
	} else {
	    const ProtocolID mppid = mp->PID();
	    error (form ("%s :%s",print(operand),mp->Print()),
		   CAN_NOT_FIND_METHOD,PidPrintname(mppid));
	    /* error (form ("ExecuteBuiltinMessage %s:%s", */
	    /*print (operand), mp->Print ()), */
	    /*"The method \"%s\" isn't defined in the class of \"%s\"", */
	    /* mp->PrintFunctor (), print (operand));*/
	    mp->Terminate ();
	}
	return;
    }
    if (!IsInlet (dest))
	fatal ("ExecuteBuiltinMessage","%s is not a inlet joint",print (dest));
    doConnect (result, MJ_NC_ptr (dest));
    mp->Free ();
}

/*-----------------
* Local Variables:
* c-indent-level:4
* c-continued-statement-offset:4
* c-brace-offset:0
* c-imaginary-offset:0
* c-argdecl-indent:4
* c-label-offset:-4
* c++-electrics-colon:t
* c++-empty-arglist-indent:nil
* c++-friend-offset:-4
* c++-member-init-indent-offset:0
* c++-continued-member-init-offset:nil
* End:
*/
