/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#include "aum/fetch.h"
#include "aum/string.h"
#include "aum/list.h"
#include "aum/vector.h"
#include "aum/builtin.h"
#include "aum/compare.h"
#include "aum/object.h"
#include "aum/derive.h"
#include "builtin/extern.h"

static const int CompareEq = 0; /* equal */
extern int CompareString (Word x, Word y);
extern int CompareAtom (Word x, Word y);
extern int CompareVector (Word x, Word y);

Word
doEq_with_dfloat (Word ax, Word ay)
    // {}
    // ư x ȥ֥ y ӤϿ
    // Ǥʤϵ֤⤷y ΰ褬ꤷƤʤ
    // ϥ桼֥Ȥλϥå롥
    // {}
{
    Word y = Dereference (ay);
    if (IsDFloat (y))
	return DFloat_Eq_p (ax, y);
    if (IsFixnum (y))
	return DFloat_Eq_p (ax, Fix2Double (y));
    if (IsSFloat (y))
	return DFloat_Eq_p (ax, Single2Double (y));
    if (IsJoint (y) || IsUserObject (y))
	return SendBuiltinMessage2 (y, PID_REV_EQ_DFLOAT, ax);
    if (IsImported (y))
	return CallAUmProgram (CreateSuperDoubleObject, PID_EQ, ax, y);
    return BOOLFALSE;
}

inline Word
doEq_with_fixnum (Word ax, Word ay)
    // {}
    //  x ȥ֥ y ӤϿ򡤤Ǥʤ
    // ϵ֤⤷y ΰ褬ꤷƤʤ뤤ϥ桼
    // ֥Ȥλϥå롥
    // {}
{
    Word y = Dereference (ay);
    if (IsFixnum (y))
	return (ax == y) ? BOOLTRUE : BOOLFALSE;
    if (IsDFloat (y))
	return DFloat_Eq_p (Fix2Double (ax), y);
    if (IsSFloat (y))
	return SFloat_Eq_p (Fix2Single (ax), y);
    if (IsUndefined (y) || IsUserObject (y))
	return SendBuiltinMessage2 (y, PID_REV_EQ_FIXNUM, ax);
    return BOOLFALSE;
}

Word
doEq_with_sfloat (Word ax, Word ay)
    // {}
    // ñư x ȥ֥ y ӤϿ
    // Ǥʤϵ֤⤷y ΰ褬ꤷƤʤ
    // ϥ桼֥Ȥλϥå롥
    // {}
{
    Word y = Dereference (ay);
    if (IsDFloat (y))
	return DFloat_Eq_p (Single2Double (ax), y);
    if (IsFixnum (y))
	return SFloat_Eq_p (ax, Fix2Single (y));
    if (IsSFloat (y))
	return SFloat_Eq_p (ax, y);
    if (IsUndefined (y) || IsUserObject (y))
	return SendBuiltinMessage2 (y, PID_REV_EQ_SFLOAT, ax);
    return BOOLFALSE;
}

Word
doEq_with_atom (Word ax, Word ay)
    // {}
    // ȥ४֥ x ȥ֥ yӤȤϿ
    // ǤʤȤϡ֤⤷y ΰ褬ꤷƤʤС
    // å롥
    // {}
{
    Word y = Dereference (ay);
    if (IsAtom (y))
	return (CompareAtom (ax, y) == CompareEq) ? BOOLTRUE : BOOLFALSE;
    if (IsUndefined (y) || IsUserObject (y))
	return SendBuiltinMessage2 (y, PID_REV_EQ_ATOM, ax);
    return BOOLFALSE;
}

Word
doEq_with_string (Word ax, Word ay)
    // {}
    // String (EUC, ASCII) ֥ x ȥ֥ yӤ, 
    // ȤϿ, ǤʤȤ, ֤. ⤷, y ΰ褬
    // ꤷƤʤ, å.
    // {}
{
    Word y = Dereference (ay);
    if (IsASCII_StrObject (y) || IsEUC_StrObject (y))
	return CompareString (ax, y) == CompareEq ? BOOLTRUE : BOOLFALSE;
    if (IsJoint (y) || IsUserObject (y))
	return SendBuiltinMessage2 (y, PID_REV_EQ_STRING, ax);
    if (IsImported (y))
	return CallAUmProgram (CreateSuperStringObject, PID_EQ, ax, y);
    return BOOLFALSE;
}

Word
doEq_with_list (Word ax, Word ay)
    // {}
    // ꥹȥ֥ x ȥ֥ yӤȤϿ
    // ǤʤȤϡ֤⤷y ΰ褬ꤷƤʤС
    // å롥
    // {}
{
    Word y = Dereference (ay);
    if (IsList (y))
	return CompareList (ax, y) == CompareEq ? BOOLTRUE : BOOLFALSE;
    if (IsJoint (y) || IsUserObject (y))
	return SendBuiltinMessage2 (y, PID_REV_EQ_LIST, ax);
    if (IsImported (y))
	return CallAUmProgram (CreateSuperListObject, PID_EQ, ax, y);
    return BOOLFALSE;
}

Word
doEq_with_vector (Word ax, Word ay)
    // {}
    // ٥֥ x ȥ֥ yӤȤϿ
    // ǤʤȤϡ֤⤷y ΰ褬ꤷƤʤС
    // å롥
    // {}
{
    Word y = Dereference (ay);
    if (IsVector (y))
	return CompareVector (ax, y) == CompareEq ? BOOLTRUE : BOOLFALSE;
    if (IsJoint (y) || IsUserObject (y))
	return SendBuiltinMessage2 (y, PID_REV_EQ_VECTOR, ax);
    if (IsImported (y))
	return CallAUmProgram (CreateSuperVectorObject, PID_EQ, ax, y);
    return BOOLFALSE;
}

Word
doEq (Word ax, Word ay)
    // {} @ METHOD BEGIN
    // {} @ CLASS compare
    // {} @ NOTATION X:eq(Y,^Z)
    // {} @ MACRO X == Y = ^Z
    // {} @ EXPLANATION
    // XYӤ,  @code{`true} , Ǥʤ
    // @code{`false} 򥹥ȥ꡼Z³롥
    // @send_when_cant_execute{Y}{eq(X,^Z)}
    // {} @ METHOD END
{
    Word x = ax;
    Word z;
 retry:
    switch (Type_of (x)) {
    case AUm_Atom:
	z = doEq_with_atom (x, ay);
	break;
    case AUm_Fixnum:
	z = doEq_with_fixnum (x, ay);
	break;
    default:
	if (IsBool (x))
	    z = IsTrue (x) ? doTrue_p (ay) : doFalse_p (ay);
	else if (IsSFloat (x))
	    z = doEq_with_sfloat (x, ay);
	else if (IsSink (x))
	    z = SINKOBJ;
	else {
	    error (form ("%s:eq(%s,^Z)", print (ax), print (ay)),
		   CAN_NOT_FIND_METHOD,"eq/+-");
	    //errmsg_undefined_method (ax));
	    return SINKOBJ;
	}
	break;
    case AUm_Object:
	switch (Pointer (x)->Type ()) {
	case CONNECTED:
	    x = J_C_ptr (x)->Destination ();
	    goto retry;
	case JOINT:
	case OBJECT:
	case IMPORTED_OBJECT:
	    z = SendBuiltinMessage2 (x, PID_EQ, ay);
	    break;
	case VECTOR:
	    z = doEq_with_vector (x, ay);
	    break;
	case LISToo:
	case LISToi:
	case LISTio:
	case LISTii:
	    z = doEq_with_list (x, ay);
	    break;
	case ASCII_STR:
	case EUC_STR:
	    z = doEq_with_string (x, ay);
	    break;
	case DFLOAT:
	    z = doEq_with_dfloat (x, ay);
	    break;
	case WC_LISToo:
	case WC_LISToi:
	case WC_LISTio:
	case WC_LISTii:
	    z = ListObject_ptr (x)->Suspended_by_elt_index (PID_EQ, ay);
	    break;
	case WC_ASCII_STR:
	    z = ASCII_StrObject_ptr (x)->Suspended_by_elt_index (PID_EQ, ay);
	    break;
	case WC_EUC_STR:
	    z = EUC_StrObject_ptr (x)->Suspended_by_elt_index (PID_EQ, ay);
	    break;
	case WC_VECTOR:
	    z = VectorObject_ptr (x)->Suspended_by_elt_index (PID_EQ, ay);
	    break;
	default:
	    error (form ("%s:eq(%s,^Z)", print (ax), print (ay)),
		   CAN_NOT_FIND_METHOD,"eq/+-");
		   //errmsg_undefined_method (ax));
	    return SINKOBJ;
	    break;
	}
    }
    doClose (ay);
    return z;
}

METHOD (equal, R3_OP)
    // {}
    // equal Ri, Rj, Rk
    // {}
    // [	   address ]
    // [  Ri|  Rj|  Rk|	  0]
    // {}
    // Ri  Rj Ӥ롥ʤ `true 򤽤Ǥʤ
    // `false Rk ˥åȤ롥
    // {}
{
    Fetch4 ();
    Word x = Reg[ip->b0];
    Reg[ip->b2] = doEq (x, Reg[ip->b1]);
    doClose (x);
    JumpNextInstruction ();
}

Word
doRevEq_atom (Word ay, Word ax)
    // {}
    // ȥ४֥ x ȥ֥ yӤȤϿ
    // ǤʤȤϡ֤⤷y ΰ褬ꤷƤʤС
    // å롥
    // {}
{
    Word y = Dereference (ay);
    if (IsAtom (y))
	return (CompareAtom (ax, y) == CompareEq) ? BOOLTRUE : BOOLFALSE;
    return BOOLFALSE;
}

Word
doRevEq_string (Word ay, Word ax)
    // {}
    // ʸ x ȥ֥ y ӤϿ򡤤Ǥʤ
    // ϵ֤
    // {}
{
    Word y = Dereference (ay);
    if (IsString (ax))
	return doEq_with_string (ax, y);
    return CallAUmProgram (CreateSuperStringObject, PID_REV_EQ_STRING, y, ax);
}

Word
doRevEq_list (Word ay, Word ax)
    // {}
    // ꥹ x ȥ֥ y ӤϿ򡤤Ǥʤ
    // ϵ֤
    // {}
{
    Word y = Dereference (ay);
    if (IsList (ax))
	return doEq_with_list (ax, y);
    return CallAUmProgram (CreateSuperListObject, PID_REV_EQ_LIST, y, ax);
}

Word
doRevEq_vector (Word ay, Word ax)
    // {}
    // ٥ x ȥ֥ y ӤϿ򡤤Ǥʤ
    // ϵ֤
    // {}
{
    Word y = Dereference (ay);
    if (IsVector (ax))
	return doEq_with_vector (ax, y);
    return CallAUmProgram (CreateSuperVectorObject, PID_REV_EQ_VECTOR, y, ax);
}

Word
doRevEq_fixnum (Word ay, Word ax)
    // {}
    // ؿ doEq(Word, Word) ǰդˤƥåä
    // ν򤹤롥x ϡ٤Ǥ뤳ȤʬäƤ롥
    // {}
{
    Word y = Dereference (ay);
    if (IsFixnum (y))
	return Fixnum_Eq_p (ax, y);
    if (IsDFloat (y))
	return DFloat_Eq_p (Fix2Double (ax), y);
    if (IsSFloat (y))
	return SFloat_Eq_p (Fix2Single (ax), y);
    return BOOLFALSE;
}

Word
doRevEq_sfloat (Word ay, Word ax)
    // {}
    // ؿ doEq(Word, Word) ǰդˤƥåä
    // ν򤹤롥x ϡñư٤Ǥ뤳ȤʬäƤ
    // 롥
    // {}
{
    Word y = Dereference (ay);
    if (IsDFloat (y))
	return DFloat_Eq_p (Single2Double (ax), y);
    if (IsSFloat (y))
	return SFloat_Eq_p (ax, y);
    if (IsFixnum (y))
	return SFloat_Eq_p (ax, Fix2Single (y));
    return BOOLFALSE;
}

Word
doRevEq_dfloat (Word ay, Word ax)
    // {}
    // ؿ doEq(Word, Word) ǰդˤƥåä
    // ν򤹤롥x ϡư٤Ǥ뤳ȤʬäƤ
    // 롥
    // {}
{
    Word y = Dereference (ay);
    if (IsDFloat (y))
	return DFloat_Eq_p (ax, y);
    if (IsFixnum (y))
	return DFloat_Eq_p (ax, Fix2Double (y));
    if (IsSFloat (y))
	return DFloat_Eq_p (ax, Single2Double (y));
    return BOOLFALSE;
}

/*-----------------
* Local Variables:
* c-indent-level:4
* c-continued-statement-offset:4
* c-brace-offset:0
* c-imaginary-offset:0
* c-argdecl-indent:4
* c-label-offset:-4
* c++-electric-colon:t
* c++-empty-arglist-indent:nil
* c++-friend-offset:-4
* c++-member-init-indent-offset:0
* c++-continued-member-init-offset:nil
* End:
*/
