/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#include "aum/fetch.h"
#include "aum/string.h"
#include "aum/list.h"
#include "aum/builtin.h"
#include "aum/msgobj.h"
#include "aum/vector.h"
#include "builtin/extern.h"

extern Word doCaro (Word);

static const char *
eltoform (const char* cn, Word x, Word y)
{
    return form ("%s :elt(%s,^Z) [%s]", print (x), print (y),cn);
}

static const char *
eltoform (Word cn, Word x, Word y)
{
    return form ("%s :elt(%s,^Z) [%s]", print (x), print (y), print(cn));
}

static const char *
eltoform (Word x, Word y)
{
    return form ("%s :elt(%s,^Z)", print (x), print (y));
}

Word
doEltoListObject (Word x, Word y)
{
    y = Dereference (y);
    if (IsFixnum (y)) {
	int	index = Fix2Int (y);
	if (index < 0) {
	    error (eltoform (Classnamelist, x, y), OUT_OF_INDEX_RANGE);
	    return INT0;
	}
	Word	list = doNthList (x, index);
	if (IsINT0 (list)) {
	    error (eltoform (Classnamelist, x, y),
		   OUT_OF_INDEX_RANGE);
	    return INT0;
	}
	return doCaro (list);
    }
    error (eltoform (Classnamelist, x, y),
	   INDEX_MUST_BE_INTEGER);
    return INT0;
}

Word
doEltoVectorObject (Word ax, Word ay)
{
    Word y = Dereference (ay);
    if (IsFixnum (y)) {
	VectorObject *vect = (VectorObject *) Pointer (ax);
	int	index = Fix2Int (y);
	if (index < 0 || index >= vect->GetSize ()) {
	    error (eltoform (ClassNameVector, ax, ay), OUT_OF_INDEX_RANGE);
	    return INT0;
	}
	Word	ans = vect->GetElement (index);
	if (vect->GetMode (index) == 'i') {
	    error (eltoform (ClassNameVector, ax, ay),
		   "%s[%d] is an inlet", print (ax), index);
	    return INT0;
	}
	doSplit (ans);
	return ans;
    }
    if (IsUndefined (y))
	return VectorObject_ptr (ax)->Wait_for_elt_index (PID_ELT_O, y);
    error (eltoform (ClassNameVector, ax, ay),
	   INDEX_MUST_BE_INTEGER);
    return INT0;
}

Word
doEltoString (Word x, Word y)
{
    y = Dereference (y);
    if (IsFixnum (y)) {
	int	index = Fix2Int (y);
	int	length = StringObject_ptr (x)->no_of_chars ();
	if (index < 0 || index >= length) {
	    error (eltoform (ClassNameString, x, y), OUT_OF_INDEX_RANGE);
	    return INT0;
	}
	if (IsASCII_StrObject (x))
	    return ASCII_StrObject_ptr (x)->Element (index);
	else
	    return EUC_StrObject_ptr (x)->Element (index);
    }
    if (IsUndefined (y)) {
	if (IsASCII_StrObject (x))
	    return ASCII_StrObject_ptr (x)->Wait_for_elt_index (PID_ELT_O, y);
	else
	    return EUC_StrObject_ptr (x)->Wait_for_elt_index (PID_ELT_O, y);
    }
    error (eltoform (ClassNameString, x, y),INDEX_MUST_BE_INTEGER);
    return INT0;
}

Word
doEltoMessageObject (Word x, Word y)
{
    y = Dereference (y);
    if (IsFixnum (y)) {
	MessageObject *messobj = (MessageObject *) Pointer (x);
	Message *mess = messobj->GetMessage ();
	ProtocolID pid = mess->PID ();
	int	index = Fix2Int (y);
	if (index < 0 || index >= pid.Arity ()) {
	    error (eltoform (ClassNameMessage, x, y), OUT_OF_INDEX_RANGE);
	    return INT0;
	}
	Word	ans = mess->Argv (index);
	if (pid.IsInlet (index)) {
	    error (eltoform (ClassNameMessage, x, y),
		   "%dth argument is an inlet.",index);
	    return INT0;
	}
	doSplit (ans);
	return ans;
    }
    error (eltoform (ClassNameMessage, x, y),
	   INDEX_MUST_BE_INTEGER);
    return INT0;
}

Word
doElto (Word ax, Word ay)
    // {} @ METHOD BEGIN
    // {} @ CLASS     sequence
    // {} @ NOTATION  X:elt(Y,^Z)
    // {} @ EXPLANATION
    // XYܤǤ򥹥ȥ꡼Z³롥YǤʤƤϤ
    // ʤY̤³Υ祤ȤξY³ޤԤġ
    // {} @ METHOD END
{
    Word x = Dereference (ax);
    Word z;
    if (IsObject (x)) {
	switch (Pointer (x)->oTag ()) {
	case LISTii:
	case LISTio:
	case LISToi:
	case LISToo:
	    /* z = doEltoListObject (x, ay); */
	    goto error_occurred;
	    break;

	case VECTOR:
	    z = doEltoVectorObject (x, ay);
	    break;

	case MESSAGE_OBJ:
	    z = doEltoMessageObject (x, ay);
	    break;

	case ASCII_STR:
	case EUC_STR:
	    z = doEltoString (x, ay);
	    break;

	case JOINT:
	case OBJECT:
	case IMPORTED_OBJECT:
	    z = SendBuiltinMessage2 (x, PID_ELT_O, ay);
	    break;

	case WC_LISTii:
	case WC_LISTio:
	case WC_LISToi:
	case WC_LISToo:
	    /* z = ListObject_ptr (x)->Suspended_by_elt_index (PID_ELT_O, ay); */
	    goto error_occurred;
	    break;

	case WC_VECTOR:
	    z = VectorObject_ptr (x)->Suspended_by_elt_index (PID_ELT_O, ay);
	    break;

	case WC_MESSAGE_OBJ:
	    z = MessageObject_ptr (x)->Suspended_by_elt_index (PID_ELT_O, ay);
	    break;

	case WC_ASCII_STR:
	    z = ASCII_StrObject_ptr (x)->Suspended_by_elt_index (PID_ELT_O, ay);
	    break;

	case WC_EUC_STR:
	    z = EUC_StrObject_ptr (x)->Suspended_by_elt_index (PID_ELT_O, ay);
	    break;

	default:
	    goto error_occurred;
	}
    }
    else if (IsSink (x)) {
	z = SINKOBJ;
    }
    else {
	error_occurred:
	error (eltoform (x, ay),CAN_NOT_FIND_METHOD,"elt/+-");
	return INT0;
    }
    doClose (ay);
    return z;
}

METHOD (elto, R3_OP)
    // {}
    // elto Ri, Rj, Rk
    // {}
    // [	   address ]
    // [  Ri|  Rj|  Rk|	  0]
    // {}
    // Ri  Rj ܤǤ Rk ˥åȤ롥
    // {}
{
    Fetch4 ();
    Word x = Reg[ip->b0];
    Reg[ip->b2] = doElto (x, Reg[ip->b1]);
    doClose (x);
    JumpNextInstruction ();
}

/*-----------------
* Local Variables:
* c-indent-level:4
* c-continued-statement-offset:4
* c-brace-offset:0
* c-imaginary-offset:0
* c-argdecl-indent:4
* c-label-offset:-4
* c++-electric-colon:t
* c++-empty-arglist-indent:nil
* c++-friend-offset:-4
* c++-member-init-indent-offset:0
* c++-continued-member-init-offset:nil
* End:
*/
