/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#include "aum/fetch.h"
#include "aum/string.h"
#include "aum/list.h"
#include "aum/builtin.h"
#include "aum/msgobj.h"
#include "aum/vector.h"
#include "builtin/extern.h"

extern Word doCari (Word);

static const char *
eltiform (const char* cn, Word x, Word y)
{
    return form ("%s :elt(%s,Z) [%s]", print (x), print (y),cn);
}

static const char *
eltiform (Word cn, Word x, Word y)
{
    return form ("%s :elt(%s,Z) [%s]", print (x), print (y), print(cn));
}

static const char *
eltiform (Word x, Word y)
{
    return form ("%s :elt(%s,Z)", print (x), print (y));
}

Word
doEltiListObject (Word x, Word y)
{
    y = Dereference (y);
    if (IsFixnum (y)) {
	int	index = Fix2Int (y);
	if (index < 0) {
	    error (eltiform (Classnamelist, x, y), OUT_OF_INDEX_RANGE);
	    return INT0;
	}
	Word	list = doNthList (x, index);
	if (IsINT0 (list)) {
	    error (eltiform (Classnamelist, x, y), OUT_OF_INDEX_RANGE);
	    return INT0;
	}
	return doCari (list);
    }
    error (eltiform(Classnamelist, x, y), INDEX_MUST_BE_INTEGER);
    return INT0;
}

Word
doEltiVectorObject (Word x, Word y)
{
    y = Dereference (y) ;
    if (IsFixnum (y)) {
	VectorObject *vect = (VectorObject *) Pointer (x);
	int	index = Fix2Int (y);
	if (index < 0 || index >= vect->GetSize ()) {
	    error (eltiform (ClassNameVector, x, y),
		   OUT_OF_INDEX_RANGE);
	    return INT0;
	}
	Word	ans = vect->GetElement (index);
	if (vect->GetMode (index) == 'i') {
	    if (!IsUndefInlet (ans)) {
		vect->SetElement (index, UNDEFINLET, 'i');
		return ans;
	    }
	}
	error (eltiform (ClassNameVector, x, y),
	       "%s[%d] is not an inlet or uninitialized", print (x), index);
	return INT0;
    }
    if (IsUndefined (y))
	return VectorObject_ptr (x)->Wait_for_elt_index (PID_ELT_I, y);
    error (eltiform (ClassNameVector, x, y),
	   INDEX_MUST_BE_INTEGER);
    return INT0;
}

Word
doEltiMessageObject (Word x, Word y)
{
    y = Dereference (y);
    if (IsFixnum (y)) {
	MessageObject *messobj = (MessageObject *) Pointer (x);
	Message *mess = messobj->GetMessage ();
	ProtocolID pid = mess->PID ();
	int	index = Fix2Int (y);
	if (index < 0 || index >= pid.Arity ()) {
	    error (eltiform (ClassNameMessage, x, y),
		   OUT_OF_INDEX_RANGE);
	    return INT0;
	}
	Word	ans = mess->Argv (index);
	if (pid.IsInlet (index)) {
	    return ans;
	}
	error (eltiform (ClassNameMessage, x, y),
	       "%dth argument is outlet.",index);
	return INT0;
    }
    error (eltiform (ClassNameMessage, x, y),INDEX_MUST_BE_INTEGER);
    return INT0;
}

Word
doElti (Word ax, Word ay)
    // {} @ METHOD BEGIN
    // {} @ CLASS  sequence
    // {} @ NOTATION X:elt(Y,Z)
    // {} @ EXPLANATION
    // XYܤüȥ꡼ФZ³롥
    // ФYܤǤϽƤʤüȤʤ롥
    //
    // YǤʤƤϤʤʤY̤³Υ祤ȤξY
    // ³ޤԤġʳΥǡξϥ顼Ǥ
    // 롥
    //
    // YܤǤüʤХ顼ǤꡤX 󤢤
    // ϥåǤʤƤϤʤʤ
    // {} @ METHOD END
{
    Word x = Dereference (ax);
    Word z;
    if (IsObject (x)) {
	switch (Pointer (x)->oTag ()) {
	case WC_LISTii:
	case WC_LISTio:
	case WC_LISToi:
	case WC_LISToo:
	    /* z = ListObject_ptr (x)->Suspended_by_elt_index (PID_ELT_I, ay); */
	    goto error_occurred;
	    break;

	case LISTii:
	case LISTio:
	case LISToi:
	case LISToo:
	    /* z = doEltiListObject (x, ay); */
	    goto error_occurred;
	    break;

	case VECTOR:
	    z = doEltiVectorObject (x, ay);
	    break;

	case WC_VECTOR:
	    z = VectorObject_ptr (x)->Suspended_by_elt_index (PID_ELT_I, ay);
	    break;

	case WC_MESSAGE_OBJ:
	    z = MessageObject_ptr (x)->Suspended_by_elt_index (PID_ELT_I, ay);
	    break;

	case MESSAGE_OBJ:
	    z = doEltiMessageObject (x, ay);
	    break;

	case JOINT:
	case OBJECT:
	case IMPORTED_OBJECT:
	    z = SendBuiltinMessage2 (x, PID_ELT_I, ay);
	    break;

	default:
	    goto error_occurred;
	}
    } else if (IsSink (x)) {
	z = new_Merger (1);
    } else {
    error_occurred:
	error (eltiform (x, ay),CAN_NOT_FIND_METHOD,"elt/++");
	return INT0;
    }
    doClose (ay);
    return z;
}

METHOD (elti, R3_OP)
    // {}
    // elti Ri, Rj, Rk
    // {}
    // [	   address ]
    // [  Ri|  Rj|  Rk|	  0]
    // {}
    // Ri  Rj ܤǤ Rk ˥åȤ롥
    // {}
{
    Fetch4 ();
    Word x = Reg[ip->b0];
    Reg[ip->b2] = doElti (x, Reg[ip->b1]);
    doClose (x);
    JumpNextInstruction ();
}

/*-----------------
* Local Variables:
* c-indent-level:4
* c-continued-statement-offset:4
* c-brace-offset:0
* c-imaginary-offset:0
* c-argdecl-indent:4
* c-label-offset:-4
* c++-electric-colon:t
* c++-empty-arglist-indent:nil
* c++-friend-offset:-4
* c++-member-init-indent-offset:0
* c++-continued-member-init-offset:nil
* End:
*/
