/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#include "aum/fetch.h"
#include "aum/protocolid.h"
#include "aum/msgobj.h"
#include "aum/vector.h"
#include "aum/string.h"
#include "builtin/extern.h"

static const char *
dirform (Word cn, Word x, Word y)
{
    return form ("%s :dir(%s,^Z) [%s]", print (x), print (y), print(cn));
}

Word
doDirVectorObject (Word x, Word y)
{
    y = Dereference (y);
    if (IsFixnum (y)) {
	VectorObject *vect = (VectorObject *) Pointer (x);
	int	index = Fix2Int (y);
	if (index < 0 || index >= vect->GetSize ()) {
	    error (dirform (ClassNameVector, x, y), OUT_OF_INDEX_RANGE);
	    return INT0;
	}
	if (vect->GetMode (index) == 'i')
	    return InternAtom ("in");
	else
	    return InternAtom ("out");
    }
    if (IsUndefined (y))
	return VectorObject_ptr (x)->Wait_for_elt_index (PID_DIR, y);
    error (dirform (ClassNameVector,x, y), INDEX_MUST_BE_INTEGER);
    return INT0;
}

Word
doDirStringObject (Word x, Word y)
{
    y = Dereference (y);
    if (IsFixnum (y)) {
	int	index = Fix2Int (y);
	int	length = StringObject_ptr (x)->no_of_chars ();
	if (index < 0 || index >= length) {
	    error (dirform (ClassNameString, x, y), OUT_OF_INDEX_RANGE);
	    return INT0;
	}
	return InternAtom ("out");
    }
    error (dirform (ClassNameString,x, y), INDEX_MUST_BE_INTEGER);
    return INT0;
}

Word
doDirMessageObject (Word x, Word y)
{
    y = Dereference (y);
    if (IsFixnum (y)) {
	MessageObject *messobj = (MessageObject *) Pointer (x);
	Message *mess = messobj->GetMessage ();
	ProtocolID pid = mess->PID ();
	int	index = Fix2Int (y);
	if (index < 0 || index >= pid.Arity ()) {
	    error (dirform (ClassNameMessage, x, y), OUT_OF_INDEX_RANGE);
	    return INT0;
	}
	if (pid.IsInlet (index))
	    return InternAtom ("in");
	else
	    return InternAtom ("out");
    }
    error (dirform (ClassNameMessage, x, y), INDEX_MUST_BE_INTEGER);
    return INT0;
}

Word
doDir (Word ax, Word ay)
    // {} @ METHOD BEGIN
    // {} @ CLASS  sequence
    // {} @ NOTATION X:dir(Y,^Z)
    // {} @ EXPLANATION
    // XYܤǤ᥹ȥ꡼ Z ³롥ȥ꡼Z
    // ˤ ܥ @samp{in} ޤ @samp{out} ³졤줾
    // ȥ꡼(ü)(ü)ɽ
    //
    // YǤʤƤϤʤʤY祤Ȥξ礬³
    // ޤԤġ
    //
    // X ʸξϾ @samp{out} Ȥʤ롥
    // {} @ METHOD END
{
    Word x = Dereference (ax);
    Word z;
    if (IsObject (x)) {
	switch (Pointer (x)->oTag ()) {
	case LISTii:
	case LISTio:
	case LISToi:
	case LISToo:
	    goto error_occurred;
	    break;

	case VECTOR:
	    z = doDirVectorObject (x, ay);
	    break;

	case MESSAGE_OBJ:
	    z = doDirMessageObject (x, ay);
	    break;

	case ASCII_STR:
	case EUC_STR:
	    z = doDirStringObject (x, ay);
	    break;

	case JOINT:
	case OBJECT:
	case IMPORTED_OBJECT:
	    z = SendBuiltinMessage2 (x, PID_DIR, ay);
	    break;

	case WC_LISTii:
	case WC_LISTio:
	case WC_LISToi:
	case WC_LISToo:
	    /*z = ListObject_ptr (x)->Suspended_by_elt_index (PID_DIR, ay);*/
	    goto error_occurred;
	    break;

	case WC_VECTOR:
	    z = VectorObject_ptr (x)->Suspended_by_elt_index (PID_DIR, ay);
	    break;

	case WC_MESSAGE_OBJ:
	    z = MessageObject_ptr (x)->Suspended_by_elt_index (PID_DIR, ay);
	    break;

	case WC_ASCII_STR:
	    z = ASCII_StrObject_ptr (x)->Suspended_by_elt_index (PID_DIR, ay);
	    break;

	case WC_EUC_STR:
	    z = EUC_StrObject_ptr (x)->Suspended_by_elt_index (PID_DIR, ay);
	    break;

	default:
	    goto error_occurred;
	}
    }
    else if (IsSink (x)) {
	z = SINKOBJ;
    }
    else {
	error_occurred:
	error (form ("%s :dir(%s,^Z) ", print (x), print (ay)),
	       CAN_NOT_FIND_METHOD,"dir/+-");
	return INT0;
    }
    doClose (ay);
    return z;
}

METHOD (dir, R3_OP)
    // {}
    // dir Ri, Rj, Rk
    // {}
    // [	   address ]
    // [  Ri|  Rj|  Rk|	 00]
    // {}
    // Ri  Rj ܤΥ⡼ɤ Rk 롥
    // {}
{
    Fetch4 ();
    Word x = Reg[ip->b0];
    Reg[ip->b2] = doDir (x, Reg[ip->b1]);
    doClose (x);
    JumpNextInstruction ();
}

/*-----------------
* Local Variables:
* c-indent-level:4
* c-continued-statement-offset:4
* c-brace-offset:0
* c-imaginary-offset:0
* c-argdecl-indent:4
* c-label-offset:-4
* c++-electric-colon:t
* c++-empty-arglist-indent:nil
* c++-friend-offset:-4
* c++-member-init-indent-offset:0
* c++-continued-member-init-offset:nil
* End:
*/
