/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#include <stream.h>
#include "aum/fetch.h"
#include "aum/close.h"
#include "aum/error.h"
#include "aum/trace.h"
#include "aum/tstream.h"
#include "aum/stdlib.h"
#include "aum/string.h"
#include "utils/cconv.h"

static void
doDebugio_print (Word ax)
{
    int	    save = TraceStream->Level ();
    TraceStream->Level (50);
    {
	Boolean old_p = String_quote_p;
	String_quote_p = FALSE;
	const char* string = print (ax);
	String_quote_p = old_p;
	cout << string;
    }
    TraceStream->Level (save);
}

METHOD (debugio_print, R1_OP)
    // {}
    // debugio_print Ri;
    // {}
    // [	   address ]
    // [  Ri|	0|	  0]
    // {}
    // δؿϥǥХåѤ˺졤Ri ƤɸϤ˰뤿
    // Ѥ롥
    // {}
{
    Fetch112 ();
    Word x = Reg[ip->b0];
    doDebugio_print (x);
    doClose (x);
    JumpNextInstruction ();
}

static void
doDebugio_putc (Word ax)
{
    Word x = Dereference (ax);
    if (IsFixnum (x)) {
	unsigned int u = (unsigned int) Fix2Int(x);
	unsigned int l = (u >> 8) & 0xFF;
	if (l)
	    cout.form("%c", char (l));
	cout.form ("%c", char (u & 0xFF));
    }
    else {
	fatal ("debugio_putc", "%s is not a integer", print (ax));
    }
}

METHOD (debugio_putc, R1_OP)
    // {}
    // debugio_putc Ri;
    // {}
    // [	   address ]
    // [  Ri|	0|	  0]
    // {}
    // δؿϥǥХåѤ˺졤Ri ͤʸȤɸϤ
    // 뤿Ѥ롥
    // {}
{
    Fetch112 ();
    Word x = Reg[ip->b0];
    doDebugio_putc (x);
    doClose (x);
    JumpNextInstruction ();
}

static void
doDebugio_flush ()
{
    cout.flush ();
}

METHOD (debugio_flush, NO_OP)
    // {}
    // debugio_flush;
    // {}
    // [	   address ]
    // {}
    // δؿϥǥХåѤ˺졤ɸϤեå夹뤿
    // 롥
    // {}
{
    doDebugio_flush ();

    InstructionPointer += 1;
    DO_TRACE_INSTRUCTION;
    JUMPNEXT;
}

METHOD (show, R1_OP)
    // {}
    // show Ri;
    // {}
    // [	   address ]
    // [  Ri|	0|	  0]
    // {}
    // δؿϥǥХåѤ˺졤Ri ɸϤ˰뤿Ѥ
    // 롥
    // {}
{
    Fetch112 ();
    int	    save = TraceStream->Level ();
    TraceStream->Level (50);
    Trace->Show (ip->b0);
    TraceStream->Level (save);
    JumpNextInstruction ();
}

Word doDebugio_getc ()
{
    unsigned char w;
    cin.get (w);
    if (w > DEL) {
	if (w < SJC){
	    /*shift jis*/
	    unsigned char c2;
	    cin.get (c2);
	    if (c2 > SJS) {
		int s = (w <= 0x9f) ? 0x00e1 : 0x0161;
		w *= 2;
		w -= s;
		int sec = c2;
		if (sec >= 0x9f){
		    sec = sec - 0x7e;
		    w++;
		}else{
		    int sp = (sec > DEL) ? 32 : 31;
		    sec = sec - sp;
		}
		int ret = (((w & 0x7f) | 0x080)<<8) + ((sec & 0x7f) | 0x080);
		return Int2Fix(ret);
	    }
	}else if (w < EJC) {
	    unsigned char c3;
	    cin.get (c3);
	    /*euc*/
	    return Int2Fix((((w & 0x7f) | 0x080)<<8) + ((c3 & 0x7f) | 0x080));
	}
    }
    return Int2Fix(w);
}

METHOD (debugio_getc, R1_OP)
    // {}
    // debugio_getc Ri;
    // {}
    // [	   address ]
    // [  Ri|	0|	  0]
    // {}
    // δؿϥǥХåѤ˺졤Ri ʸȤɸϤ
    // Ϥ뤿Ѥ롥
    // {}
{
    Fetch112 ();
    Reg[ip->b0] = doDebugio_getc ();
    JumpNextInstruction ();
}

/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-brace-offset:0
 * c-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-electric-colon:t
 * c++-empty-arglist-indent:nil
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */
