/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#include "aum/vector.h"
#include "aum/fetch.h"
#include "aum/stdlib.h"
#include "builtin/extern.h"

Word
doYCreateVector (Word ax, Word ay)
{
    Word y = Dereference (ay);
    return CreateVector (Fix2Int (ax), y);
}

Word
doCreateVector (Word ax, Word ay)
{
    Word x = Dereference (ax);
    if (IsFixnum (x))
	return doYCreateVector (x, ay);
    if (IsUndefined (x))
	return SendBuiltinMessage2 (x, PID_CREATE_VECTOR, ay);
    error (form ("create vector 3 %s %s", print (x), print (ay)),
	   "Can't coerce %s to INTEGER", print (x));
    return INT0;
}

METHOD (create_vector3, R3_OP)
// {}
// create_vector3 Ri, Rs, Rfill
// {}
// [	       address ]
// [  Ri| Rs|  Rf| 0x00]
// {}
// 󥪥֥Ȥ롥
// {}
{
    // {*} @ METHOD BEGIN
    // {*} @ CLASS vector
    // {*} NOTATION ##vector:new(X):init(Y) = ^Z (?)
    // {*} EXPLANATION
    // ٥֥Ȥ롥֥XͤǼʬ
    // ΰˡͤȤƤΥ֥Ȥϡ֡롢ñ
    // ټ¿ȥΤ줫˸ꤵ롥
    // {*} @ METHOD END
    Fetch4 ();
    Reg[ip->b0] = doCreateVector (Reg[ip->b1], Reg[ip->b2]);
    JumpNextInstruction ();
}

METHOD (create_vector2, R2_OP)
// {}
// create_vector2 Ri, Rs
// {}
// [	       address ]
// [  Ri|  Rs|	 0x0000]
// {}
// 󥪥֥Ȥ롥
// {}
{
    // {*} @ METHOD BEGIN
    // {*} @ CLASS  vector
    // {*} @ NOTATION ##vector:new(X) = ^Y (?)
    // {*} EXPLANATION
    // ٥֥Ȥ롥Ǥν̤ͤνü
    // {*} @ METHOD END
    Fetch4 ();
    Reg[ip->b0] = doCreateVector (Reg[ip->b1], UNDEFOUTLET);
    JumpNextInstruction ();
}

/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-brace-offset:0
 * c-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-electric-colon:t
 * c++-empty-arglist-indent:nil
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */
