/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#include <ctype.h>
#include "aum.h"
#include "aum/protocolid.h"
#include "aum/merger.h"
#include "builtin/extern.h"
#include "aum/string.h"

METHOD(create_string2, R1Dc_OP)
    // {}
    // create_string2 Ri, Ls
    // {}
    // [	   address ]
    // [  Ri|	0|	 Ls]
    // {}
    // ʸ󥪥֥Ȥ롥
    // {}
{
    // {*} @ METHOD BEGIN
    // {*} @ CLASS string
    // {*} @ NOTATION ##string:new(X):initialize("String") = ^Z
    // {*} @ EXPLANATION
    // ʸ󥪥֥Ȥ롥
    // {*} @ METHOD END
    Fetch112();
    Reg[ip->b0] = CopyString((Word)(*(InstructionPointer+ip->s0)));
    JumpNextInstruction();
}

Word doCreateStringObject(Word x, Word y)
{
    int fill = Fix2Int(y);
    int size = Fix2Int(x);
    if(size < 0){
	error(form("create_string3 %s %s",print(x),print(y)),
	      "illegal size %s ",print(x));
	return INT0;
    }
    Word ret;
    if(isascii(fill)){
	ret = CreateASCIIString(fill,size);
    }else{
	ret = CreateEUCString(fill,size);
    }
    return ret;
}

Word doYCreateString(Word x, Word y)
{
    y = Dereference (y);
    if (IsUndefined (y))
	return SendBuiltinMessage2(y, PID_REV_CREATE_STRING, x);
    if (IsFixnum(y))
	return doCreateStringObject(x,y);
    error(form("create_string3 %s %s",print(x),print(y)),
	  "Can't coerce %s to INTEGER",print(y));
    return INT0;
}

Word doRevCreateString(Word y, Word x)
{
    y = Dereference (y);
    if (IsFixnum(y))
	return doCreateStringObject(x,y);
    error(form("reverse create string3 %s %s",print(x),print(y)),
	  "Invalid Object Type %s",print(y));
    return INT0;
}

Word doCreateString(Word x, Word y)
{
    x = Dereference (x);
    if (IsUndefined (x))
	return SendBuiltinMessage2(x,PID_CREATE_STRING,y);
    if (IsFixnum(x))
	return doYCreateString(x,y);
    error(form("create_string3 %s %s ",print(x),print(y)),
	  "Can't coerce %s to INTEGER",print(x));
    return INT0;
}

METHOD(create_string3, R3_OP)
    // {}
    // create_string3 Ri, Rsize, Rfill
    // {}
    // [	   address ]
    // [  Ri|Rsize|Rfill|00]
    // {}
    // ʸ󥪥֥Ȥ롥
    // {}
{
    // {*} @ METHOD BEGIN
    // {*} @ CLASS string
    // {*} NOTATION  ##string:new(X):initialize(Y) = ^Z
    // {*} @ EXPLANATION
    // ʸ󥪥֥Ȥ롥֥XϵΰΥ򼨤
    // ֥Yϡʸɤ򼨤
    // {*} @ METHOD END
    Fetch4();
    Reg[ip->b0] = doCreateString(Reg[ip->b1],Reg[ip->b2]);
    JumpNextInstruction();
}


/*-----------------
* Local Variables:
* c-indent-level:4
* c-continued-statement-offset:4
* c-brace-offset:0
* c-imaginary-offset:0
* c-argdecl-indent:4
* c-label-offset:-4
* c++-electric-colon:t
* c++-empty-arglist-indent:nil
* c++-friend-offset:-4
* c++-member-init-indent-offset:0
* c++-continued-member-init-offset:nil
* End:
*/

