/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#include "aum.h"
#include "aum/builtin.h"
#include "aum/msgobj.h"
#include "aum/protocolid.h"
#include "aum/merger.h"
#include "builtin/extern.h"

extern LocalMessage*  CreateMessage(u_char,const ProtocolID&);

METHOD(create_integer, R1Vi_OP)
    // {}
    // create_integer Ri, Vi
    // {}
    // [	   address ]
    // [  Ri|	0|	  0]
    // [		 Vi]
    // {}
    // ֥Ȥ롥
    // {}
{
    // {*} @ METHOD BEGIN
    // {*} @ CLASS integer
    // {*} @ NOTATION ##integer:new:init(1) = ^X
    // {*} @ EXPLANATION
    // ֥Ȥ롥
    // {*} @ METHOD END

    Fetch1val();
    Reg[ip->b0] = ip->wval;
    JumpNextInstruction();
}

METHOD(create_double, R1Do_OP)
    // {}
    // create_double Ri, Vd
    // {}
    // [	   address ]
    // [  Ri|	0|	 Ld]
    // {}
    // ư롥
    // {}
{
    // {*} @ METHOD BEGIN
    // {*} @ CLASS double
    // {*} @ NOTATION ##double:new:init(1.0) = ^X
    // {*} @ EXPLANATION
    // ư֥Ȥ롥
    // {*} @ METHOD END
    Fetch112();
    Reg[ip->b0] = CopyDFloat(*(InstructionPointer+ip->s0));
    JumpNextInstruction();
}

METHOD(create_atom, R1Vi_OP)
    // {}
    // create_atom Ri, Va
    // {}
    // [	   address ]
    // [  Ri|	0|	  0]
    // [		 Va]
    // {}
    // ȥ४֥Ȥ롥
    // {}
{
    // {*} @ METHOD BEGIN
    // {*} @ CLASS atom
    // {*} @ NOTATION ##atom:new = ^X
    // {*} @ EXPLANATION
    // ȥ४֥Ȥ롥
    // {*} @ METHOD END
    Fetch1val();
    Reg[ip->b0] = ip->wval;
    JumpNextInstruction();
}

METHOD(create_bool, R1Vi_OP)
    // {}
    // create_bool Ri, Va
    // {}
    // [	   address ]
    // [  Ri|	0|	  0]
    // [		 Va]
    // {}
    // ֥ͥȤ롥
    // {}
{
    // {*} @ METHOD BEGIN
    // {*} @ bool
    // {*} @ NOTATION ##bool:new:init(`true) = ^X
    // {*} @ EXPLANATION
    // ֡륪֥Ȥ롥
    // {*} @ METHOD END
    Fetch1val();
    Reg[ip->b0] = ip->wval;
    JumpNextInstruction();
}

METHOD(create_class, R1D1_OP)
    // {}
    // create_class Ri, Vc
    // {}
    // [	   address ]
    // [  Ri|	0|	 Lc]
    // {}
    // 饹֥Ȥ롥
    // {}
{
    // {*} @ METHOD BEGIN
    // {*} @ CLASS class
    // {*} @ NOTATION ##user_defined_class:new:init(xxxxx) = ^X
    // {*} @ EXPLANATION
    // 饹֥Ȥ롥
    // {*} @ METHOD END
    Fetch112();
    Reg[ip->b0] = CreateClass((ClassTmpl*)*(InstructionPointer+ip->s0));
    JumpNextInstruction();
}

METHOD(create_float, R1Vi_OP)
    // {}
    // create_float Ri, Vf
    // {}
    // [	   address ]
    // [  Ri|	0|	  0]
    // [		 Vf]
    // {}
    // ñư롥
    // {}
{
    // {*} @ METHOD BEGIN
    // {*} @ CLASS float
    // {*} @ NOTATION ##float:new:init(1.0) = ^X
    // {*} @ EXPLANATION
    // ñư֥Ȥ롥
    // {*} @ METHOD END
    Fetch1val();
    Reg[ip->b0] = ip->wval;
    JumpNextInstruction();
}

METHOD(create_sink, R1_OP)
    // {}
    // create_sink Ri
    // {}
    // [	   address ]
    // [  Ri|	0|	  0]
    // {}
    // 󥯥֥Ȥ롥
    // {}
{
    // {*} @ METHOD BEGIN
    // {*} @ CLASS sink
    // {*} @ NOTATION ##sink:new = ^X
    // {*} @ EXPLANATION
    // 󥯥֥Ȥ롥
    // {*} @ METHOD END
    Fetch112();
    Reg[ip->b0] = SINKOBJ;
    JumpNextInstruction();
}

Word doCreateMessage(Word x)
{
    x = Dereference (x);
    if (IsUndefined (x)){
	return SendBuiltinMessage1(x,PID_CREATE_MESSAGE);
    }
    if (IsFixnum(x)){
	int argc = Fix2Int(x);
	return new_MessageObject ((Message*)CreateMessage
				  (argc,InternProtocolID(InternAtom(""),
							 argc,(u_long)0x0)));
    }
    return INT0;
}

METHOD(create_message_object, R2_OP)
    // {}
    // create_message_object  Rm, Rarg_size
    // {}
    // [	   address ]
    // [  Rm| Ras|  00|	 00]
    // {}
    // å֥Ȥ롥
    // {}
{
    // {*} @ METHOD BEGIN
    // {*} @ CLASS message
    // {*} @ NOTATION ##string:new(X):initialize(Y) = ^Z
    // {*} @ EXPLANATION
    // ʸ󥪥֥Ȥ롥֥XϵΰΥ򼨤
    // ֥Yϡʸɤ򼨤
    // {*} @ METHOD END
    Fetch4();
    Reg[ip->b0] = doCreateMessage(Reg[ip->b1]);
    JumpNextInstruction();
}

/*-----------------
* Local Variables:
* c-indent-level:4
* c-continued-statement-offset:4
* c-brace-offset:0
* c-imaginary-offset:0
* c-argdecl-indent:4
* c-label-offset:-4
* c++-electric-colon:t
* c++-empty-arglist-indent:nil
* c++-friend-offset:-4
* c++-member-init-indent-offset:0
* c++-continued-member-init-offset:nil
* End:
*/
