/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#include "aum/object.h"
#include "aum/builtin.h"
#include "aum/string.h"
#include "builtin/extern.h"

// ΥեˤϡƱ索֥ȤӴؿѰդƤ롥

static const int CompareLt = (-1);	/* less than */
static const int CompareEq = 0; /* equal */
static const int CompareGt = 1; /* greater than */
static const int CompareUk = 1; /* unknown */

int
CompareFixnum (Word x, Word y)
// {}
// 
// (1) x == y return 0
// (2) x >  y return > 0
// (3) x <  y return < 0
// {}
{
    return (int (x) - int (y));
}

int
CompareSFloat (Word x, Word y)
// {}
// ñư
// (1) x == y return 0
// (2) x >  y return 1
// (3) x <  y return -1
// {}
{
    float   xf = Single2float (x);
    float   yf = Single2float (y);
    if (xf == yf)
	return CompareEq;
    if (xf > yf)
	return CompareGt;
    return CompareLt;
}

extern Name AtomPrintname (Word x);

int
CompareAtom (Word x, Word y)
// {}
// ȥ
// ȥֹ椬 0 ֤
// Ǥʤϰ̾Ӥ򤹤롥
// {}
{
    if (AtomNumber (x) == AtomNumber (y))
	return CompareEq;
    return strcmp (AtomPrintname (x), AtomPrintname (y));
}

int
CompareBool (Word x, Word y)
// {}
// ͤ
// (1) x = `true  && y = `true	return 0
// (2) x = `false && y = `false return 0
// (3) x = `true  && y = `false return 1
// (4) x = `false && y = `true	return 1
// % true > false
// {}
{
    if (IsTrue (x))
	return IsTrue (y) ? CompareEq : CompareGt;
    return IsFalse (y) ? CompareEq : CompareLt;
}

extern int CompareList (Word, Word);

extern int CompareVector (Word x, Word y);
extern int CompareDFloat (Word x, Word y);
extern int CompareClass (Word x, Word y);
extern int CompareMessage (Word x, Word y);
extern int CompareForeign (Word x, Word y);

int
IsConvertableASCII (Word x)
{
    int	    ret = 1;
    EUC_StrObject *str = (EUC_StrObject *) Pointer (x);
    Uint    slen = str->no_of_chars ();
    for (Uint counter = 0; counter < slen;) {
	if (IsEUC ((u_short) Fix2Int (str->Element (counter++)))) {
	    return 0;
	}
    }
    return ret;
}

int
CompareEUCwithObject (Word &x, Word &y)
{
    int	    ret = CompareUk;
    EUC_StrObject *eucstr = (EUC_StrObject *) Pointer (x);
    Uint    xlen = eucstr->no_of_chars ();
    if (IsObject (y)) {
	Uint	count;
	ObjectTag t = Pointer (y)->Type ();
	if (t == EUC_STR) {
	    EUC_StrObject *euc = (EUC_StrObject *) Pointer (y);
	    Uint    ylen = euc->no_of_chars ();
	    Uint    clen = (ylen > xlen) ? xlen : ylen;
	    for (count = 0; count < clen; count++) {
		u_short rl = (u_short) Fix2Int (eucstr->Element (count));
		u_short ll = (u_short) Fix2Int (euc->Element (count));
		if (rl > ll)
		    return CompareGt;
		if (rl < ll)
		    return CompareLt;
	    }
	    if (xlen > ylen)
		return CompareGt;
	    if (xlen < ylen)
		return CompareLt;
	    return CompareEq;
	}
	if (t == ASCII_STR) {
	    ASCII_StrObject *ascii = (ASCII_StrObject *) Pointer (y);
	    Uint    ylen = ascii->no_of_chars ();
	    Uint    clen = (ylen > xlen) ? xlen : ylen;
	    for (count = 0; count < clen; count++) {
		u_short rl = (u_short) Fix2Int (eucstr->Element (count));
		u_short ll = (u_short) Fix2Int (ascii->Element (count));
		if (rl > ll)
		    return CompareGt;
		if (rl < ll)
		    return CompareLt;
	    }
	    if (xlen > ylen)
		return CompareGt;
	    if (xlen < ylen)
		return CompareLt;
	    return CompareEq;
	}
    }
    return ret;
}
int
CompareASCIIwithObject (Word &x, Word &y)
{
    int	    ret = CompareUk;
    ASCII_StrObject *asciistr = (ASCII_StrObject *) Pointer (x);
    Uint    xlen = asciistr->no_of_chars ();
    if (IsObject (y)) {
	Uint	count;
	ObjectTag t = Pointer (y)->Type ();
	if (t == EUC_STR) {
	    EUC_StrObject *euc = (EUC_StrObject *) Pointer (y);
	    Uint    ylen = euc->no_of_chars ();
	    Uint    clen = (ylen > xlen) ? xlen : ylen;
	    for (count = 0; count < clen; count++) {
		u_short rl = (u_short) Fix2Int (asciistr->Element (count));
		u_short ll = (u_short) Fix2Int (euc->Element (count));
		if (rl > ll)
		    return CompareGt;
		if (rl < ll)
		    return CompareLt;
	    }
	    if (xlen > ylen)
		return CompareGt;
	    if (xlen < ylen)
		return CompareLt;
	    return CompareEq;
	}
	if (t == ASCII_STR) {
	    ASCII_StrObject *ascii = (ASCII_StrObject *) Pointer (y);
	    Uint    ylen = ascii->no_of_chars ();
	    Uint    clen = (ylen > xlen) ? xlen : ylen;
	    for (count = 0; count < clen; count++) {
		u_short rl = (u_short) Fix2Int (asciistr->Element (count));
		u_short ll = (u_short) Fix2Int (ascii->Element (count));
		if (rl > ll)
		    return CompareGt;
		if (rl < ll)
		    return CompareLt;
	    }
	    if (xlen > ylen)
		return CompareGt;
	    if (xlen < ylen)
		return CompareLt;
	    return CompareEq;
	}
    }
    return ret;
}

int
CompareString (Word x, Word y)
{
    int	    ret = CompareUk;
    if (IsObject (x)) {
	ObjectTag t = Pointer (x)->Type ();
	if (t == EUC_STR)
	    return CompareEUCwithObject (x, y);
	if (t == ASCII_STR)
	    return CompareASCIIwithObject (x, y);
    }
    return ret;
}

int
CompareBuiltin (Word x, Word y)
// {}
// ȹ֥Ȥ
// {}
{
    switch (Type_of (x)) {
    case AUm_Atom:
	if (Type_of (y) == AUm_Atom)
	    return x - y;
	return CompareUk;
    case AUm_Fixnum:
	switch (Type_of (y)) {
	case AUm_Fixnum:
	    return CompareFixnum (x, y);
	case AUm_Constant:
	    if (IsSFloat (y))
		return CompareSFloat (Fix2Single (x), y);
	    break;
	case AUm_Object:
	    if ((Pointer (y)->Type ()) == DFLOAT)
		return CompareDFloat (Fix2Double (x), y);
	    break;
	default:
	    break;
	}
	break;
    case AUm_Constant:
	if (IsSFloat (x)) {
	    switch (Type_of (y)) {
	    case AUm_Fixnum:
		return CompareSFloat (x, Fix2Single (y));
	    case AUm_Constant:
		if (IsSFloat (y))
		    return CompareSFloat (x, y);
		break;
	    case AUm_Object:
		if (ObjectType (y) == DFLOAT)
		    return CompareDFloat (Single2Double (x), y);
		break;
	    default:
		break;
	    }
	}
	break;
    case AUm_Object:
	switch (ObjectType (x)) {
	case LISToo:
	case LISToi:
	case LISTio:
	case LISTii:
	    return CompareList (x, y);
	case ASCII_STR:
	case EUC_STR:
	    if (IsASCII_StrObject (y) || IsEUC_StrObject (y)) {
		return CompareString (x, y);
	    }
	    break;
	case VECTOR:
	    if ((Type_of (y) == AUm_Object) && (ObjectType (y) == VECTOR)) {
		return CompareVector (x, y);
	    }
	    break;
	case DFLOAT:
	    if (Type_of (y) == AUm_Fixnum) {
		return CompareDFloat (x, Fix2Double (y));
	    }
	    if (IsSFloat (y)) {
		return CompareDFloat (x, Single2Double (y));
	    }
	    if ((Type_of (y) == AUm_Object)
		&& (ObjectType (y) == DFLOAT)) {
		return CompareDFloat (x, y);
	    }
	    break;
	case CLASS_OBJ:
	    return CompareClass (x, y);
	case MESSAGE_OBJ:
	    return CompareMessage (x, y);
	case FOREIGN_OBJ:
	    return CompareForeign (x, y);
	default:
	    break;
	}
    default:
	break;
    }
    return CompareUk;
}

int
CompareObject (Word x, Word y)
// {}
// ̥֥Ȥ
// {}
{
    return (Object_ptr (x) - Object_ptr (y));
}

/*-----------------
* Local Variables:
* c-indent-level:4
* c-continued-statement-offset:4
* c-brace-offset:0
* c-imaginary-offset:0
* c-argdecl-indent:4
* c-label-offset:-4
* c++-electric-colon:t
* c++-empty-arglist-indent:nil
* c++-friend-offset:-4
* c++-member-init-indent-offset:0
* c++-continued-member-init-offset:nil
* End:
*/
