/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#include "aum/fetch.h"
#include "aum/protocolid.h"
#include "aum/merger.h"
#include "aum/string.h"
#include "aum/vector.h"
#include "aum/object.h"
#include "builtin/extern.h"

Word	ClassNameInteger;
Word	ClassNameSFloat;
Word	ClassNameAtom;
Word	ClassNameBool;
Word	ClassNameList;
Word	ClassNameString;
Word	ClassNameVector;
Word	ClassNameDFloat;
Word	ClassNameClass;
Word	ClassNameMessage;
Word	ClassNameForeign;
Word	ClassNameFileStream;

Word
doClassof (Word ax)
    // {} @ METHOD BEGIN
    // {} @ CLASS object
    // {} @ NOTATION X:classof(^Y)
    // {} @ MACRO    classof X = ^Y
    // {} @ EXPLANATION
    // X Υ饹̾򥷥ܥȤơȥ꡼Y³롥X桼
    // 饹Υ֥Ȥξ硤ǽ餽Υ饹ǻȤǤ
    // @code{class_of/-} õĤʤäˤϡ桼
    // 饹̾򥷥ܥȤƥȥ꡼Y³롥
    // X ȹ֥ȤʤСΥ饹̾򼡤ΥܥȤ֤
    // @table @samp
    // @item symbol
    // ܥ
    // @item integer
    // 
    // @item single_float
    // ñư
    // @item double_float
    // ư
    // @item boolean
    // 
    // @item list
    // ꥹ
    // @item vector
    // 
    // @item string
    // ʸ
    // @item message
    // å֥
    // @item file_stream
    // ե륪֥
    // @end table
    // {} @ METHOD END
{
    Word x = ax;
retry:
    switch (Type_of (x)) {
    case AUm_Object:
	switch (ObjectType (x)) {
	case CONNECTED:
	    x = J_C_ptr (x)->Destination ();
	    goto retry;
	case CLASS_OBJ:
	    return ClassNameClass;
	case FOREIGN_OBJ:
	    return ClassNameForeign;
	case MESSAGE_OBJ:
	    return ClassNameMessage;
	case VECTOR:
	case WC_VECTOR:
	    return ClassNameVector;
	case DFLOAT:
	    return ClassNameDFloat;
	case EUC_STR:
	case ASCII_STR:
	case WC_ASCII_STR:
	case WC_EUC_STR:
	    return ClassNameString;
	case LISToo:
	case LISToi:
	case LISTio:
	case LISTii:
	case WC_LISToo:
	case WC_LISToi:
	case WC_LISTio:
	case WC_LISTii:
	    return ClassNameList;
	case FILE_STREAM:
	    return ClassNameFileStream;
	case JOINT:
	case OBJECT:
	case IMPORTED_OBJECT:
	    return SendBuiltinMessage1 (x, PID_CLASSOF);
	default:
	    break;
	}
	break;
    case AUm_Fixnum:
	return ClassNameInteger;
    case AUm_Atom:
	return ClassNameAtom;
    case AUm_Constant:
	if (IsSFloat (x))
	    return ClassNameSFloat;
	if (IsBool (x))
	    return ClassNameBool;
    default:
	break;
    }
    error (form("%s:classof(^Y)",print(x)),CAN_NOT_FIND_METHOD,"classof/-");
    return SINKOBJ;
}

METHOD (classof, R2_OP)
    // {}
    // classof Ri, Rj
    // {}
    // [	   address ]
    // [  Ri|  Rj|	  0]
    // {}
    // ֥ Ri Υ饹̾򥢥ȥȤƼФ Rj ˥åȤ롥
    // {}
{
    Fetch112 ();
    Word x = Reg[ip->b0];
    Reg[ip->b1] = doClassof (x);
    doClose (x);
    JumpNextInstruction ();
}

//////////////////////////////////////////////////////////////////

Word
doClass_name (Word ax)
    // {} @ METHOD BEGIN
    // {} @ CLASS object
    // {} @ NOTATION X:class_name(^Y)
    // {} @ EXPLANATION
    // X Υ饹̾򥷥ܥȤơȥ꡼Y³롥
    // {} @ METHOD END
{
    Word x = Dereference (ax);
    if (IsObject (x)) {
	switch (Pointer (x)->oTag ()) {
	case JOINT:
	    return SendBuiltinMessage1 (x, PID_CLASS_NAME);
	case OBJECT:
	    return Object_ptr (x)->ClassName ();
	default:
	    break;
	}
    }
    return doClassof (x);
}

METHOD (class_name, R2_OP)
    // {}
    // class_of Ri, Rj
    // {}
    // [	   address ]
    // [  Ri|  Rj|	  0]
    // {}
    // ֥ Ri Υ饹̾򥢥ȥȤ Rj ˥åȤ롥
    // {}
{
    Fetch112 ();
    Word x = Reg[ip->b0];
    Reg[ip->b1] = doClass_name (x);
    doClose (x);
    JumpNextInstruction ();
}

/*-----------------
* Local Variables:
* c-indent-level:4
* c-continued-statement-offset:4
* c-brace-offset:0
* c-imaginary-offset:0
* c-argdecl-indent:4
* c-label-offset:-4
* c++-electric-colon:t
* c++-empty-arglist-indent:nil
* c++-friend-offset:-4
* c++-member-init-indent-offset:0
* c++-continued-member-init-offset:nil
* End:
*/
