/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#include "aum/builtin.h"
#include "aum/object.h"
#include "aum/tstream.h"
#include "aum/alloc.h"
#include "class/template.h"

// Υեˤϡ饹֥Ȥ˴ؤ桼ƥƥ򽸤᤿

class ClassObject;
extern Name AtomPrintname(Word a);

void ClassObject::Initialize(ClassTmpl* ct)
    // {}
    // 饹֥Ȥν򤹤롥
    // {}
{
    Header::Initialize(CLASS_OBJ, 1);
    classtmpl = ct;
}

void ClassObject::Free()
    // {}
    // 饹֥Ȥΰ롣
    // {}
{
    SHARED_FREE(this, sizeof(ClassObject));
    return;
}

Name ClassObject::Print()
    // {}
    // 饹֥Ȥΰ᡼ʸȤ֤
    // {}
{
    char tem[BUFSIZ];
    tstream tout = tstream(BUFSIZ, tem);
    tout.form("#%s", (char*)AtomPrintname(classtmpl->ClassName()));
    return tout.Result();
}

Word CreateClass(ClassTmpl* ct)
    // {}
    // 饹֥Ȥ롥
    // {}
{
    ClassObject* cx = (ClassObject*)SHARED_ALLOC(sizeof(ClassObject));
    cx->Initialize(ct);
    return ObjectWord(cx);
}

void DeleteClass(Word x)
    // {}
    // 饹֥Ȥ롥
    // {}
{
    ClassObject* cx = (ClassObject*)Object_ptr(x);
    cx->Free();
    return;
}

void PrintClass(Word x)
    // {}
    // 饹֥ȤϤ롥
    // {}
{
    ClassObject* cp = (ClassObject*)Object_ptr(x);
    cout << cp->Print();
    return;
}

int CompareClass(Word x, Word y)
    // {}
    // 饹֥ȤӤ򤹤롥
    // {}
{
    ClassObject* cx = (ClassObject*)Object_ptr(x);
    ClassObject* cy = (ClassObject*)Object_ptr(y);
    if (cx->classtmpl == cy->classtmpl) return 0;
    return cx->classtmpl > cy->classtmpl ? 1 : -1;
}

Name ClassPrintImage(Word x)
    // {}
    // 饹֥ȤΰɽʸȤ֤
    // {}
{
    ClassObject* cx = (ClassObject*)Object_ptr(x);
    return cx->Print();
}

/*-----------------
* Local Variables:
* c-indent-level:4
* c-continued-statement-offset:4
* c-brace-offset:0
* c-imaginary-offset:0
* c-argdecl-indent:4
* c-label-offset:-4
* c++-electric-colon:t
* c++-empty-arglist-indent:nil
* c++-friend-offset:-4
* c++-member-init-indent-offset:0
* c++-continued-member-init-offset:nil
* End:
*/
