/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/
#include <stream.h>
#include <stdarg.h>
#include "aum/global.h"
#include "aum/fetch.h"
#include "aum/builtin.h"
#include "aum/stdlib.h"
#include "aum/error.h"
#include "aum/object.h"
#include "builtin/extern.h"

#define NOT(x) IsTrue(x) ? BOOLFALSE : BOOLTRUE
#define doBitAndObj(x,y) (Int2Fix(Fix2Int(x) & Fix2Int(y)))
#define doBitXorObj(x,y) (Int2Fix(Fix2Int(x) ^ Fix2Int(y)))
#define doBitOrObj(x,y) (Int2Fix(Fix2Int(x) | Fix2Int(y)))

const char IS_NOT_INTEGER[] = "%s is not an integer";

void
trace (const char *fmt)
{
    cerr << fmt << "\n";
}

Word boolean_error (const char *str, Word ay)
{
    error (str, "%s is not a boolean object", print (ay));
    return INT0;
}

static const char *
notform (Word x)
{
    return form ("%s:not(^Z)", print (x));
}

static const char *
booleanform (Word x, Word y,const char* op)
{
    return form ("%s:%s(%s,^Z)", print(x),op,print(y));
}

Word
doNot (Word ax)
    // {} @ METHOD BEGIN
    // {} @ CLASS     bool integer
    // {} @ NOTATION  X:not(^Y)
    // {} @ MACRO     not X = ^Y
    // {} @ EXPLANATION
    // XͤʤԤ̤򥹥ȥ꡼Y³롥X
    // ʤӥåȿžԤ̤򥹥ȥ꡼Y³롥
    // {} @ METHOD END
{
    Word x = Dereference (ax);
    if (IsFixnum (x))
	return Int2Fix (~Fix2Int (x));
    if (IsTrue (x))
	return BOOLFALSE;
    if (IsFalse (x))
	return BOOLTRUE;
    if (IsUndefined (x) || IsUserObject (x))
	return SendBuiltinMessage1 (x, PID_NOT);
    error (notform(ax),CAN_NOT_FIND_METHOD,"not/-");
    return INT0;
}

METHOD (not, R2_OP)
    // {}
    // not Ri, Rj
    // {}
    // [	   address ]
    // [  Ri|  Rj|	  0]
    // {}
    //  Ri ꡤη̤ Rj ˥åȤ롥
    // {}
{
    Fetch112 ();
    Word x = Reg[ip->b0];
    Reg[ip->b1] = doNot (x);
    doClose (x);
    JumpNextInstruction ();
}

////////////////////////////////////////////////////////////////

Word
doRevBitAnd (Word ay, Word ax)
    // {}
    // doBitAnd()ǰȿž줿ν
    //  x ȥ֥ y ѤȤ롥
    // {}
{
    Word y = Dereference (ay);
    if (IsFixnum (y))
	return doBitAndObj (ax, y);
    error (booleanform (ax, ay,"rev_and"),CAN_NOT_FIND_METHOD ,"rev_and/+-");
    return INT0;
}

Word
doBitAnd (Word ax, Word ay)
    // {}
    //  x ȥ֥ y ѤȤ롥
    // ⤷֥ y ޡ㡼ʤå롥
    // {}
{
    Word y = Dereference (ay);
    if (IsFixnum (y)) {
	return doBitAndObj (ax, y);
    }
    if (IsUndefined (y) || IsUserObject (y)) {
	return SendBuiltinMessage2 (y, PID_REV_BIT_AND, ax);
    }
    error (booleanform (ax, ay, "and"),IS_NOT_INTEGER, print (ay));
    return INT0;
}

Word
doAnd (Word ax, Word ay)
    // {} @ METHOD BEGIN
    // {} @ CLASS  bool integer
    // {} @ NOTATION X:and(Y,^Z)
    // {} @ MACRO    X and Y = ^Z
    // {} @ EXPLANATION
    // X  YȤͤʤξԤΥ֡ѤȤꡤ
    // 򥹥ȥ꡼Z³롥X  Y ȤʤХӥåȤ
    // ѤȤꡤ̤򥹥ȥ꡼Z³롥
    // @send_when_cant_execute{Y}{and(X,^Z)}
    // {} @ METHOD END
{
    Word x = Dereference (ax);
    Word z;

    if (IsFixnum (x)) {
	z = doBitAnd (x, ay);
    } else if (IsTrue (x)) {
	z = doTrue_p (ay);
    } else if (IsFalse (x)) {
	z = doFalse_p (ay);
    } else if (IsUndefined (x) || IsUserObject (x)) {
	z = SendBuiltinMessage2 (x, PID_AND, ay);
    } else {
	error (booleanform (ax, ay,"and"), CAN_NOT_FIND_METHOD ,"and/+-");
	z = SINKOBJ;
    }
    doClose (ay);
    return z;
}

METHOD (and, R3_OP)
    // {}
    // and Ri, Rj, Rk
    // {}
    // [	   address ]
    // [  Ri|  Rj|  Rk|	  0]
    // {}
    // Ri  Rj Ѥꡤη̤ Rk ˥åȤ롥
    // {}
{
    Fetch4 ();
    Word x = Reg[ip->b0];
    Reg[ip->b2] = doAnd (x, Reg[ip->b1]);
    doClose (x);
    JumpNextInstruction ();
}

//////////////////////////////////////////////////////////////////
Word
doRevBitOr (Word ay, Word ax)
    // {}
    // doBitOr()ǰȿž줿ν
    //  x ȥ֥ y Υӥå¤Ȥ롥
{
    Word y = Dereference (ay);
    if (IsFixnum (y))
	return doBitOrObj (ax, y);
    error (booleanform (ax, ay,"rev_or"), CAN_NOT_FIND_METHOD ,"rev_or/+-");
    return INT0;
}

Word
doBitOr (Word ax, Word ay)
    // {}
    //  x ȥ֥ y Υӥå¤Ȥ롥
    // ⤷֥ y ޡ㡼ʤå롥
    // {}
{
    Word y = Dereference (ay);
    if (IsFixnum (y))
	return doBitOrObj (ax, y);
    if (IsUndefined (y))
	return SendBuiltinMessage2 (y, PID_REV_BIT_OR, ax);
    error (booleanform (ax, ay,"or"),
	   IS_NOT_INTEGER, print (ay));
    return INT0;
}

Word
doOr (Word ax, Word ay)
    // {} @ METHOD BEGIN
    // {} @ CLASS bool integer
    // {} @ NOTATION X:or(Y,^Z)
    // {} @ MACRO X or Y = ^Z
    // {} @ EXPLANATION
    // X  Y ȤͤʤξԤΥ֡¤Ȥꡤ
    // ̤򥹥ȥ꡼Z³롥X  Y ȤʤХӥåȤ
    // ¤Ȥꡤ̤򥹥ȥ꡼Z³롥
    // @send_when_cant_execute{Y}{or(X,^Z)}
    // {} @ METHOD END
{
    Word x = Dereference (ax);
    Word z;
    if (IsFixnum (x))
	z = doBitOr (x, ay);
    else if (IsTrue (x))
	z = BOOLTRUE;
    else if (IsFalse (x))
	z = doTrue_p (ay);
    else if (IsUndefined (x) || IsUserObject (x))
	z = SendBuiltinMessage2 (x, PID_OR, ay);
    else {
	error (booleanform (ax, ay,"or"),
	       CAN_NOT_FIND_METHOD,"or/+-");
	z = SINKOBJ;
    }
    doClose (ay);
    return z;
}

METHOD (or, R3_OP)
    // {}
    // or Ri, Rj, Rk
    // {}
    // [	   address ]
    // [  Ri|  Rj|  Rk|	  0]
    // {}
    // Ri  Rj ¤ꡤη̤ Rk ˥åȤ롥
    // {}
{
    Fetch4 ();
    Word x = Reg[ip->b0];
    Reg[ip->b2] = doOr (x, Reg[ip->b1]);
    doClose (x);
    JumpNextInstruction ();
}

Word
doRevBitXor (Word ay, Word ax)
    // {}
    // doBitXor()ǰȿž줿ν
    //  x ȥ֥ y ¾Ū¤Ȥ롥
    // {}
{
    Word y = Dereference (ay);
    if (IsFixnum (y))
	return doBitXorObj (ax, y);
    error (booleanform (ax, ay,"rev_xor"),CAN_NOT_FIND_METHOD ,"rev_xor/+-");
    return INT0;
}

Word
doBitXor (Word ax, Word ay)
    // {}
    //  x ȥ֥ y ¾Ū¤Ȥ롥
    // ⤷֥ y ޡ㡼ʤå롥
    // {}
{
    Word y = Dereference (ay);
    if (IsFixnum (y))
	return doBitXorObj (ax, y);
    if (IsUndefined (y))
	return SendBuiltinMessage2 (y, PID_REV_BIT_XOR, ax);
    error (booleanform (ax, ay,"xor"),IS_NOT_INTEGER, print (ay));
    return INT0;
}

Word
doXor (Word ax, Word ay)
    // {} @ METHOD BEGIN
    // {} @ CLASS bool integer
    // {} @ NOTATION X:xor(Y,^Z)
    // {} @ MACRO X xor Y = ^Z
    // {} @ EXPLANATION
    // X  Y ȤͤʤξԤΥ֡¾Ū¤Ȥꡤ
    // ̤򥹥ȥ꡼Z³롥X  Y  ȤʤХӥåȤ
    // ¾Ū¤Ȥꡤ̤򥹥ȥ꡼Z³롥
    // @send_when_cant_execute{Y}{xor(X,^Z)}
    // {} @ METHOD END
{
    Word x = Dereference (ax);
    Word z;
    if (IsFixnum (x))
	z = doBitXor (x, ay);
    else if (IsTrue (x))
	z = doFalse_p (ay);
    else if (IsFalse (x))
	z = doTrue_p (ay);
    else if (IsUndefined (x) || IsUserObject (x))
	z = SendBuiltinMessage2 (x, PID_XOR, ay);
    else {
	error (booleanform (ax, ay,"xor"),CAN_NOT_FIND_METHOD,"xor/+-");
	z = SINKOBJ;
    }
    doClose (ay);
    return z;
}

METHOD (xor, R3_OP)
    // {}
    // xor Ri, Rj, Rk
    // {}
    // [	   address ]
    // [  Ri|  Rj|  Rk|	  0]
    // {}
    // Ri  Rj ¾Ū¤ꡤη̤ Rk ˥åȤ롥
    // {}
{
    Fetch4 ();
    Word x = Reg[ip->b0];
    Reg[ip->b2] = doXor (x, Reg[ip->b1]);
    doClose (x);
    JumpNextInstruction ();
}

/*-----------------
* Local Variables:
* c-indent-level:4
* c-continued-statement-offset:4
* c-brace-offset:0
* c-imaginary-offset:0
* c-argdecl-indent:4
* c-label-offset:-4
* c++-electric-colon:t
* c++-empty-arglist-indent:nil
* c++-friend-offset:-4
* c++-member-init-indent-offset:0
* c++-continued-member-init-offset:nil
* End:
*/
