/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#include "aum/global.h"
#include "aum/fetch.h"
#include "aum/builtin.h"
#include "aum/string.h"
#include "builtin/extern.h"

#ifdef nodef
Word doAtom(Word x)
    // {*} @ METHOD BEGIN
    // {*} @ CLASS  atom string
    // {*} @ NOTATION  X:atom(^Y)
    // {*} @ EXPLANATION
    // XʸʤФΰ̾ĥȥ४֥Ȥ
    // ꡼Y³롥ߤΥƥǤϼ¹Ի˿
    // ФȤϤǤʤ餫᥷ƥ¸ߤ뤫ޤ
    // ϥ桼ץƤ륢ȥˤΤͭǤ롥
    // XȥʤФ򥹥ȥ꡼Y³롥
    // {*} @ METHOD END
{
    x = Dereference (x);
    if (IsAtom(x)) return x;
    if (IsEUC_StrObject(x))
	return InternAtom(EUC_StrObject_ptr(x)->Print(FALSE));
    if (IsASCII_StrObject(x))
	return InternAtom(ASCII_StrObject_ptr(x)->Print(FALSE));
    if (IsUndefined (x))
	return SendBuiltinMessage1(x,PID_ATOM);
    error(form("%s:atom(^Y)",print(x)),
	  "Can't coerce %s to STRING",print(x));
    return INT0;
}

//METHOD(atom, R2_OP)
    // {}
    //	 atom Rx , Rresult
    // {}
    // [	   address ]
    // [  Rx|  Rr|	  0]
    // {}
    //	 String ObjectΥȥಽ
    // оݥ֥
    //	 String (ASCII or EUC ) Object
    //	 (Integer,Float,Double ϰ String Ѵθ奢ȥಽԤ)
{
    Fetch4 ();
    Word x = Reg[ip->b0];
    Reg[ip->b1] = doAtom (x);
    doClose (x);
    JumpNextInstruction();
}
#endif /* nodef */

/*-----------------
* Local Variables:
* c-indent-level:4
* c-continued-statement-offset:4
* c-brace-offset:0
* c-imaginary-offset:0
* c-argdecl-indent:4
* c-label-offset:-4
* c++-electric-colon:t
* c++-empty-arglist-indent:nil
* c++-friend-offset:-4
* c++-member-init-indent-offset:0
* c++-continued-member-init-offset:nil
* End:
*/
