/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#include "aum/global.h"
#include "aum/fetch.h"
#include "aum/tstream.h"
#include "aum/builtin.h"
#include "aum/string.h"
#include "aum/list.h"
#include "aum/protocolid.h"
#include "aum/object.h"
#include "aum/derive.h"
#include "builtin/extern.h"

static const char *
appendform (Word x, Word y)
{
    return form ("%s:append(%s,^Z)", print (x), print (y));
}

Word
doAppendString (Word ax, Word ay)
    // {}
    // ʸ x ȥ֥ y Ϣ뤹ؿ֥ y ΰ褬
    // ̤λå롣
    // {}
{
    const ProtocolID pid = PID_APPEND;
    const ProtocolID rev = PID_REV_APPEND_STRING;
    Word y = Dereference (ay);

    if (IsObject (y)) {
	switch (Pointer (y)->oTag ()) {
	case ASCII_STR:
	    return ASCII_StrObject_ptr (y)->Prepend (ax);

	case EUC_STR:
	    return EUC_StrObject_ptr (y)->Prepend (ax);

	case JOINT:
	case OBJECT:
	    return SendBuiltinMessage2 (y, rev, ax);

	case IMPORTED_OBJECT:
	    return CallAUmProgram (CreateSuperStringObject, pid, ax, y);

	case WC_ASCII_STR:
	    return ASCII_StrObject_ptr (y)->Suspended_by_elt_index (rev, ax);
	    break;

	case WC_EUC_STR:
	    return EUC_StrObject_ptr (y)->Suspended_by_elt_index (rev, ax);
	    break;

	default:
	    break;
	}
    }
    error (appendform (ax, ay),
	   "the %s must be a string", print (ay));
    return INT0;
}

Word
doRevAppendString (Word ay, Word ax)
    // {}
    // ax ͢줿ʸβǽΤǡdoappendstring () ˤ
    // 롥
    // {}
{
    if (IsString (ax)) {
	return doAppendString (ax, ay);
    }
    return CallAUmProgram (CreateSuperStringObject, PID_REV_APPEND_STRING, ay, ax);
}

Word
doCopyList (Word x)
{
    Word    ret;
    ListObject *copyto = (ListObject *) Pointer ((ret = CopyList (x)));
    ListObject *source = (ListObject *) Pointer (x);
    Word    scdr = source->Cdr ();
    while (IsList (scdr)) {
	Word	cpword = CopyList (scdr);
	copyto->Cdr (cpword);
	if (source->oTag () == LISTio) {
	    source->Car (UNDEFINLET);
	}
	source = (ListObject *) Pointer (scdr);
	copyto = (ListObject *) Pointer (cpword);
	scdr = source->Cdr ();
	if (scdr == x) {
	    return ret;
	}
    }
    ObjectTag t = source->oTag ();
    if ((t == LISTio) || (t == LISTii)) {
	source->Car (UNDEFINLET);
    }
    if ((t == LISToi) || (t == LISTii)) {
	source->Cdr (UNDEFINLET);
    }
    return ret;
}

Word
AppendCopyTailList (Word & y)
{
    Word    ret;
    ListObject *source = (ListObject *) Pointer (y);
    ListObject *copyto = (ListObject *) Pointer ((ret = CopyList (y)));
loop:
    ObjectTag stype = source->oTag ();
    if (stype == LISTio) {
	source->Car (UNDEFINLET);
    }
    if (stype == LISToi) {
	source->Cdr (UNDEFINLET);
    }
    if (stype == LISTii) {
	source->Car (UNDEFINLET);
	source->Cdr (UNDEFINLET);
    }
    Word    scdr = source->Cdr ();
    if (IsList (scdr)) {
	copyto->Cdr (CopyList (scdr));
	source = (ListObject *) Pointer (scdr);
	copyto = (ListObject *) Pointer (copyto->Cdr ());
	goto loop;
    }
    return ret;
}

Word
doAppendListObject (Word x, Word y)
    // {}
    // ¼Ϣ¹ʬ
    // {}
{
    Word    list = x;
    Word    first = CreateList (LISToo, NILATOM, NILATOM);
    Word    prev = first;
    Word    cons;

    while (IsObject (list)) {
	ObjectTag otag = Pointer (list)->oTag ();
	switch (otag) {
	case LISToo:
	case LISTio:
	    cons = CreateList (otag, doCar (list), INT0);
	    ListObject_ptr (prev)->Cdr (cons);
	    prev = cons;
	    list = doCdr (list);
	    continue;

	case LISToi:
	case LISTii:
	    error (appendform (x, y),
		   "cdr must be outlet mode");
	    return INT0;
	default:
	    break;
	}
	break;
    }
    doSplit (y);
    ListObject_ptr (prev)->Cdr (y);
    list = ListObject_ptr (first)->Cdr ();
    ListObject_ptr (first)->Free ();
    return list;
}

Word
doAppendList (Word x, Word y)
    // {}
    // ꥹƱΤϢǥꥹx  ֥yϢ뤹xϥꥹȤ
    // 뤳ȤȽäƤ롣⤷y祤ȤʤСå
    // 롥
    // {}
{
    y = Dereference (y);
    if (IsList (y)) {
	Word	ans = doAppendListObject (x, y);
	doClose (y);
	return ans;
    }

    if (IsNILATOM (y)) {
	return doCopyList (x);
    }
    if (IsUndefined (y) || IsUserObject (y)) {
	return SendBuiltinMessage2 (y, PID_REV_APPEND_LIST, x);
    }

    error (appendform (x, y),
	   "Can't coerce %s to list", print (y));
    return INT0;
}

Word
doRevAppendList (Word y, Word x)
    // {}
    // ꥹƱΤϢǥꥹx  ֥yϢ뤹
    // xϥꥹȤǤ뤳ȤȽäƤ롣
    // {}
{
    y = Dereference (y);
    if (IsList (y)) {
	return doAppendListObject (x, y);
    }

    if (IsNILATOM (y)) {
	return doCopyList (x);
    }

    error (form ("%s:rev_append(%s,^Z)",print (y),print (x)),
	   CAN_NOT_FIND_METHOD,"rev_append/+-");
    return INT0;
}

Word
doAppend (Word ax, Word ay)
    // {} @ METHOD BEGIN
    // {} @ CLASS     string
    // {} @ NOTATION  x:append(y,^z)
    // {} @ EXPLANATION
    // x  yη, ʸʤСĤΥ֥
    // ȤϢ뤷֥Ȥȥ꡼z³롥
    //
    // ϢԤʤ֥ȤηˤäǤΥԡˡۤ
    // 롥
    //
    // ʸλˤϡĤΥ֥ȤĹ¤ʸ
    // xƤyƤꤹ롥
    //
    // {} @ METHOD END
    // ꥹȤλˤϡxƤĺǸǤ@code{cdr}
    // y ǤꥹȤ롥
    // {}
{
    const ProtocolID pid = PID_APPEND;
    Word x = Dereference (ax);
    Word z;

    if (IsObject (x)) {
	switch (Pointer (x)->oTag ()) {
	case LISTii:
	case LISTio:
	case LISToi:
	case LISToo:
	    goto error_occurred;
	    /* z = doAppendList (x, ay); */
	    break;

	case ASCII_STR:
	case EUC_STR:
	    z = doAppendString (x, ay);
	    break;

	case JOINT:
	case OBJECT:
	    z = SendBuiltinMessage2 (x, pid, ay);
	    break;

	case WC_LISTii:
	case WC_LISTio:
	case WC_LISToi:
	case WC_LISToo:
	    z = ListObject_ptr (x)->Suspended_by_elt_index (pid, ay);
	    break;

	case WC_ASCII_STR:
	    z = ASCII_StrObject_ptr (x)->Suspended_by_elt_index (pid, ay);
	    break;

	case WC_EUC_STR:
	    z = EUC_StrObject_ptr (x)->Suspended_by_elt_index (pid, ay);
	    break;

	default:
	    goto error_occurred;
	}
    }
    else if (IsNILATOM (x)) {
	z = doAppendList (x, ay);
    }
    else if (IsSink (x)) {
	z = SINKOBJ;
    } else {
    error_occurred:
	error (appendform(x,ay),"Can't find the method :append/+-");
	return INT0;
    }
    doClose (ay);
    return z;
}

METHOD (append, R3_OP)
    // {}
    // append Ri, Rj, Rk
    // {}
    // [	   address ]
    // [  Ri|  Rj|  Rk|	  0]
    // {}
    // Ri  Rj Ϣ뤷̤ Rk ˥åȤ롥
    // {}
{
    Fetch4 ();
    Word    x = Reg[ip->b0];
    Reg[ip->b2] = doAppend (x, Reg[ip->b1]);
    doClose (x);
    JumpNextInstruction ();
}

/*-----------------
* Local Variables:
* c-indent-level:4
* c-continued-statement-offset:4
* c-brace-offset:0
* c-imaginary-offset:0
* c-argdecl-indent:4
* c-label-offset:-4
* c++-electric-colon:t
* c++-empty-arglist-indent:nil
* c++-friend-offset:-4
* c++-member-init-indent-offset:0
* c++-continued-member-init-offset:nil
* End:
*/
