/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#ifndef aum_word_h
#define aum_word_h

#include "config.h"
#include "aum/bool.h"
#include "aum/aumtype.h"
#include "aum/types.h"

// {}
// ܸ
// {}
// ܥƥǤϡդ֥Ȥ Word ȸƤ֡Word ϣ
// ढ롥ĤϹ¤ΤǼ¸Τǥӥåȥե
// ɤʬΤǤ롥ϼȤƥǥХåѤ롥⤦Ĥ
// ӥåʤ Word Ȥեȱ黻Ȥäƥ
// ڤʬԤʤˡǤ롥
// UNION_TYPE ϥǥХåΤǤ롥
// {}
#ifdef	UNION_TYPE

typedef union word {
#ifdef	BIG_ENDIAN
    struct {
	unsigned val:30;
	unsigned tag:2;
    }	t2;
    struct {
	unsigned val:29;
	unsigned tag:3;
    }	t3;
    struct {
	unsigned val:28;
	unsigned tag:4;
    }	t4;
    struct {
	unsigned val:27;
	unsigned tag:5;
    }	t5;
    struct {
	unsigned val:26;
	unsigned tag:6;
    }	t6;
    struct {
	unsigned val:25;
	unsigned tag:7;
    }	t7;
    struct {
	unsigned val:24;
	unsigned tag:8;
    }	t8;

#else	BIG_ENDIAN
    struct {
	unsigned tag:2;
	unsigned val:30;
    }	t2;
    struct {
	unsigned tag:3;
	unsigned val:29;
    }	t3;
    struct {
	unsigned tag:4;
	unsigned val:28;
    }	t4;
    struct {
	unsigned tag:5;
	unsigned val:27;
    }	t5;
    struct {
	unsigned tag:6;
	unsigned val:26;
    }	t6;
    struct {
	unsigned tag:7;
	unsigned val:25;
    }	t7;
    struct {
	unsigned tag:8;
	unsigned val:24;
    }	t8;

#endif	BIG_ENDIAN

    unsigned  uval;
    int	      ival;
    unsigned* pval;
} Word;

#else	UNION_TYPE

typedef unsigned int	Word;

#endif	UNION_TYPE

typedef Word	(*FPWord_Word) (Word);


// {}
// ǣգܸηȽ
// {}
#ifdef	UNION_TYPE

#define Type_of(x)		((x).t2.tag)

#define IsSFloat(x)		((x).t3.tag == AUm_SFloat)   /*	   011 */
#define IsBool(x)		((x).t4.tag == AUm_Bool)  /*   0111 */

#define BooleanTag(x)		((x).t4.tag)		   /* 00000111 */
#define IsTrue(x)		((x).t5.tag == AUm_True)   /* 00000111 */
#define IsFalse(x)		((x).t5.tag == AUm_False)  /* 00010111 */

#define IsSObject(x)		((x).t4.tag == AUm_SObject)/* xxxx1111 */
#define IsSink(x)		((x).t8.tag == AUm_Sink)
#define IsUndefOutlet(x)	((x).t8.tag == AUm_UndefOutlet)
#define IsUndefInlet(x)		((x).t8.tag == AUm_UndefInlet)
#define IsUndefSlot(x)		(IsUndefInlet(x)||IsUndefOutlet(x))
#define IsErrorObject(x)	((x).t8.tag == AUm_ErrorObject)
#define IsEncodedDoubleFloat(x) ((x).t8.tag == AUm_Encoded_DFLOAT)
#define IsEncodedASCIIString(x) ((x).t8.tag == AUm_Encoded_ASCII_STR)
#define IsEncodedEUCString(x)	((x).t8.tag == AUm_Encoded_EUC_STR)
#define SObjectType_of(x)	((x).t8.tag)

#else	UNION_TYPE

#define Type_of(x)	((x)&3)
#define _bits_mask_(x,n) ((x)&((1<<(n))-1))

#define IsSFloat(x)	(_bits_mask_(x,3)==AUm_SFloat)	/*     011 */
#define IsBool(x)	(_bits_mask_(x,4)==AUm_Bool)	/*    0111 */

#define BooleanTag(x)	(_bits_mask_(x,4))
#define IsTrue(x)	(_bits_mask_(x,5)==AUm_True)	/* 0000111 */
#define IsFalse(x)	(_bits_mask_(x,5)==AUm_False)	/* 0010111 */

#define IsSObject(x)	(_bits_mask_(x,4)==AUm_SObject) /* xxxx1111 */
#define IsSink(x)		(_bits_mask_(x,8)==AUm_Sink)
#define IsUndefSlot(x)		(_bits_mask_(x,8)==AUm_UndefSlot)
#define IsUndefOutlet(x)	(_bits_mask_(x,8)==AUm_UndefOutlet)
#define IsUndefInlet(x)		(_bits_mask_(x,8)==AUm_UndefInlet)
#define IsErrorObject(x)	(_bits_mask_(x,8)==AUm_ErrorObject)
#define IsEncodedDoubleFloat(x) (_bits_mask_(x,8)==AUm_Encoded_DFLOAT)
#define IsEncodedASCIIString(x) (_bits_mask_(x,8)==AUm_Encoded_ASCII_STR)
#define IsEncodedEUCString(x)	(_bits_mask_(x,8)==AUm_Encoded_EUC_STR)
#define SObjectType_of(x)	((x)&0xff)

#endif	UNION_TYPE

#define IsFixnum(x)	(Type_of(x)==AUm_Fixnum)	/*	00 */
#define IsAtom(x)	(Type_of(x)==AUm_Atom)		/*	01 */
#define IsObject(x)	(Type_of(x)==AUm_Object)	/*	10 */
#define IsConstant(x)	(Type_of(x)==AUm_Constant)	/*	11 */


// {}
// áܡܥǡǣգܸؤѴޥ
// {}
#ifdef	UNION_TYPE

extern Word _make_word_ptr_(void* x, AUm_Type t);
extern Word _make_fixnum_(int x);
extern Word _make_sfloat_(float x);
extern Word _make_atom_(unsigned x);
extern Word _make_bool_(unsigned x);
extern Word _make_sobject_(unsigned x);

extern Word EncodedWord(unsigned x, AUm_Type t);

#else	UNION_TYPE

#define _make_word_ptr_(x,t) Word((char*)(x) + int(t))
#define _make_fixnum_(x)     Word(((x) << 2) + int(AUm_Fixnum))
#define _make_atom_(x)	     Word(((x) << 2) + int(AUm_Atom))
extern	Word _make_sfloat_(float x);
#define _make_bool_(x)	     Word(((x) << 4) + int(AUm_Bool))
#define _make_sobject_(x)    Word(((x) << 4) + int(AUm_SObject))

#define EncodedWord(x,t)     Word(((x) << 8) + int(t))

#endif	UNION_TYPE


// {}
// ǣգܸ줫áܡܥǡؤѴޥ
// {}
#ifdef	UNION_TYPE

#define _word_ptr_of_(x,t) ((x).t2.val)
#define _fixnum_val_(x)	   ((x).t2.val)
#define _atom_val_(x)	   ((x).t2.val)
#define _sfloat_val_(x)	   ((x).t4.val)
#define _bool_val_(x)	   ((x).t6.val)
#define _sobject_val_(x)   ((x).t6.val)
#define _encoded_val_(x)   ((x).t8.val)

#else	UNION_TYPE

#define _word_ptr_of_(x,t) ( (( (char *)(x) ) - (int)(t) ) )
#define _fixnum_val_(x)	   (int(x) >> 2)
#define _atom_val_(x)	   ((x) >> 2)
#define _sfloat_val_(x)	   ((x)&~0xF)
#define _bool_val_(x)	   ((x) >> 6)
#define _sobject_val_(x)   ((x) >> 6)
#define _encoded_val_(x)   ((x) >> 8)

#endif	UNION_TYPE

// {}
// ǣգܸ줫áܡܥǡؤѴޥ
// {}
#define Fix2Int(v)	int(_fixnum_val_(v))
#define AtomNumber(v)	u_long(_atom_val_(v))
#define EncodedVal(v)	int(_encoded_val_(v))
// {}
// áܡܥǡǣգܸؤѴޥ
// {}
#define ObjectWord(v)	(_make_word_ptr_(v,AUm_Object))
#define Int2Fix(v)	(_make_fixnum_(v))
#define SFloatWord(v)	(_make_sfloat_(v))
#define AtomWord(v)	(_make_atom_(v))
#define BoolWord(v)	(_make_bool_(v))
#define SObjectWord(v)	(_make_sobject_(v))

// {}
// ǣգΡؿ٤Ѵ
// {}
extern float Single2float(Word v);
extern Word  Fix2Single(Word v);	// AUm-Fixnum => AUm-SingleFloat
extern Word  Single2Fix(Word v);	// AUm-SingleFloat => AUm-Fixnum


#define Object_ptr(v)	((class Object*)(_word_ptr_of_(v,AUm_Object)))


// CONVENTION
#define IsPointer(x)	IsObject(x)
#define Pointer(v)	((class Header*)(_word_ptr_of_(v,AUm_Object)))

#define ObjectType(x)		(Pointer(x)->oTag())
#define IsBuiltinType(x,t)	(IsObject(x) && Pointer(x)->Type() == (t))

// {}
// ¾
// {}
#ifdef	UNION_TYPE

extern Word INT0;
extern Word SINKOBJ;
extern Word UNDEFOUTLET;
extern Word UNDEFINLET;
extern Word ERROROBJECT;
extern Word BOOLTRUE;
extern Word BOOLFALSE;
extern Boolean _wordeq_(Word x, Word y);

#else	UNION_TYPE

#define INT0	    0
#define SINKOBJ	    (Word)(AUm_Sink)
#define UNDEFOUTLET (Word)(AUm_UndefOutlet)
#define UNDEFINLET  (Word)(AUm_UndefInlet)
#define ERROROBJECT (Word)(AUm_ErrorObject)
#define BOOLTRUE    (Word)(AUm_True)
#define BOOLFALSE   (Word)(AUm_False)
#define _wordeq_(x,y)		((x) == (y))

#endif	UNION_TYPE

inline Boolean IsINT0(Word x)
{
    return _wordeq_(x,INT0) ? TRUE : FALSE;
}

extern Word NILATOM;
inline Boolean IsNILATOM(Word x)
{
    return _wordeq_(x,NILATOM) ? TRUE : FALSE;
}

#define WordEq(x,y)	_wordeq_(x,y)
#ifdef CLEAR_ON_FREE
#define IsGarbageCollected(x)	(_wordeq_(x,0xFFFFFFFF))
#else
#define IsGarbageCollected(x)	(FALSE)
#endif

/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-brace-offset:0
 * c-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-electric-colon:t
 * c++-empty-arglist-indent:nil
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */
#endif	/* !aum_word_h */
