/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#ifndef aum_vector_h
#define aum_vector_h

#include "aum/header.h"
#include "aum/sideeffect.h"
#include "aum/messageq.h"
#include "aum/j-nc.h"

// Vector Object /////////////////////////////////////////////////

class VectorObject : public SideEffect {
 private:
    u_short size;
    u_short nbytes;
    Word    element[1];

 public:
    void    Initialize (int size, Word init);
    void    Initialize (int size, Word *block);
    u_short GetSize () const;
    u_short no_of_bytes () const;
    char    GetMode (int index);
    Boolean IsInlet (int index);
    Word    GetElement (int index);
    void    SetElement (int index, Word x, char io);

    void    Wait_for_set_index (const ProtocolID &, Word i, Word x);
    Word    Wait_for_elt_index (const ProtocolID &, Word i);
    Word    Wait_for_subseq_position (Word index, Word a0, Word a1);
    Word    Subseq (Word, Word);
    Word    Copy ();
    void    Close ();
    void    Free ();
    Name    Print ();

    Word & operator[] (int index);

    friend class VectorObject* new_Vector (int);
    friend void PrintVector (Word x);
    friend int	CompareVector (Word x, Word y);
    friend Name VectorPrintImage (Word x);
};

inline u_short
VectorObject::GetSize () const
{
    return size;
}

inline u_short
VectorObject::no_of_bytes () const
{
    return nbytes;
}

inline	Word & VectorObject::operator[] (int index) {
    return element[index];
}

#define VectorObject_ptr(x)	((VectorObject*)Pointer(x))
#define IsVector(x) (IsBuiltinType(x,VECTOR) || IsBuiltinType(x,WC_VECTOR))

extern Word CreateVector (int size, Word init = UNDEFOUTLET);
extern Word CreateVector (int size, Word * block);

/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-brace-offset:0
 * c-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-electric-colon:t
 * c++-empty-arglist-indent:nil
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */
#endif				/* !aum_vector_h */
