/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#ifndef aum_tstream_h
#define aum_tstream_h

#ifdef IOSTREAM_2_0

#include <stdio.h>
#include <strstream.h>
#define PARENT_OSTREAM ostrstream
#define PARENT_OSTREAM_CONSTRUCTOR(siz,buf) ostrstream (buf,siz)

#else /* IOSTREAM_2_0 */

#include <stream.h>
#define PARENT_OSTREAM ostream
#define PARENT_OSTREAM_CONSTRUCTOR(siz,buf) ostream (siz,buf)

#endif /* IOSTREAM_2_0 */

class tstreambuf;

class tstream : public PARENT_OSTREAM {
private:
    static int		level;
    static tstreambuf*	linktop;
    static int		bfpages;
public:
		tstream(int sz = BUFSIZ);
		tstream(int sz, char* buf);
		~tstream();

#ifndef IOSTREAM_2_0
    tstream&	operator << (const char* s);
    tstream&	form(const char* fmt...);
    tstream&	put(const char* s);
#endif /* IOSTREAM_2_0 */

    void	Initialize();
    void	Link(tstreambuf*);
    char*	Result();
    int		TooDeep () const { return level < 0; }
    void	Enter ()	 { level--; }
    void	Exit ()		 { level++; }
    int		Level () const	 { return level; }
    void	Level (int n)	 { level = n; }
};

extern tstream* TraceStream;

/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-brace-offset:0
 * c-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-electric-colon:t
 * c++-empty-arglist-indent:nil
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */
#endif	/* !aum_tstream_h */
