/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#ifndef aum_trace_h
#define aum_trace_h

#include "aum/bool.h"
#include "aum/types.h"

class TraceParameter {
private:
    union {
	struct {
	    unsigned create:1;	// ֥¤Ӥ˥ޡɽ롥
	    unsigned destroy:1; // ֥¤Ӥ˥ޡξǤɽ롥
	    unsigned send:1;	// ȥ꡼黻ɽ롥
	    unsigned close:1;	// ȥ꡼黻ĺɽ롥
	    unsigned connect:1; // ȥ꡼黻³ɽ롥
	    unsigned receive:1; // ȥ꡼黻μɽ롥
	    unsigned isclosed:1;// ȥ꡼黻ĺФɽ롥
	}	flag;
	int	mode;
    };
    Boolean	show;		// ̿ show ưե饰

public:
    TraceParameter() {}
    Boolean	doit()		{ return mode == 0 ? FALSE : TRUE; }
    void	Initialize();
    void	SetAll();
    void	ResetAll();
    void	SetCreate()	{ flag.create  = 1; }
    void	SetDestroy()	{ flag.destroy = 1; }
    void	SetSend()	{ flag.send    = 1; }
    void	SetClose()	{ flag.close   = 1; }
    void	SetConnect()	{ flag.connect = 1; }
    void	SetReceive()	{ flag.receive = 1; }
    void	SetIsClosed()	{ flag.isclosed= 1; }
    void	EnableShow()	{ show = TRUE; }
    //
    void	ResetCreate()	{ flag.create  = 0; }
    void	ResetDestroy()	{ flag.destroy = 0; }
    void	ResetSend()	{ flag.send    = 0; }
    void	ResetClose()	{ flag.close   = 0; }
    void	ResetConnect()	{ flag.connect = 0; }
    void	ResetReceive()	{ flag.receive = 0; }
    void	ResetIsClosed() { flag.isclosed= 0; }
    void	DisableShow()	{ show = FALSE; }
    //
    void	Create(Name tag, Name object, Name option = Name(0));
    void	Destroy(Name tag, Name object);
    void	BeginSend(Name dest, Name msg);
    void	EndSend(Name rest);
    void	BeginClose(Name dest);
    void	EndClose(Name dest);
    void	Connect(Name src, Name dest);
    void	Receive();
    void	IsClosed();
    void	Show(int i);
};

extern class TraceParameter*	Trace;
extern Boolean	TraceMessage;
extern Boolean	TraceInstruction;
extern Boolean	Verbose;
extern Boolean	ShowRC;

extern void	Initialize_Trace();
extern void	mlog2(const char*, Word);
extern void	mlog3(const char*, Word, const class Message*);
extern void	mlog4(const char*, const char*, const char*, const char*);
extern void	mlog_mon (const char*, Word);
extern void	mlog_bin (Word, const char*, Word);

/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-brace-offset:0
 * c-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-electric-colon:t
 * c++-empty-arglist-indent:nil
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */
#endif	/* !aum_trace_h */
