/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#ifndef aum_string_h
#define aum_string_h

#include <string.h>
#include "aum/sideeffect.h"
#include "aum/word.h"
#include "aum/protocolid.h"
#include "aum/message.h"

class MessageLink;
class StringObject;
class ASCII_StrObject;
class EUC_StrObject;

#define roundup(x,n)	( ((x) + (n) - 1) & ~((n) - 1))
#define IsEUC(x)	((x)&0x80)

/* look new_Iam_copy () */
#define MAX_STRING_BYTES	(0xFFFF - MIN_MESSAGE_SIZE - sizeof (Word))

// \\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\
// String Object ///////////////////////////////////////////////////
// \\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\

// {}
// ʸ󥪥֥Ȥϲ۴ؿ(virtual function)ȤСäȴñ
// ˽񤱤뤳ȤʬäƤ롥ѥ餬۴ؿѤ˥֥
// Ȥ礭򣱥䤹ΤȹͤʳǤϲ۴ؿ
// ѤƤʤ
// {}
class StringObject : public SideEffect {
 protected:
    u_short nbytes;
    u_short nchars;

 public:
    inline Length no_of_chars () const;
    inline Length no_of_bytes () const;
    inline int Copyfrom (StringObject *);
    void    Free ();
};

inline Length
StringObject::no_of_bytes ()
const
    // {}
    // ʸ礭Хȿ֤
    // {}
{
    return nbytes;
}

inline Length
StringObject::no_of_chars ()
const
    // {}
    // ʸˤɤޤʸäƤ뤫ʸ֤
    // {}
{
    return nchars;
}

inline int
StringObject::Copyfrom (StringObject * from)
{
    memcpy (this, from, from->no_of_bytes ());
    return nbytes / sizeof (Word);
}

#define IsString(x)		(IsASCII_StrObject(x) || IsEUC_StrObject(x))
#define StringObject_ptr(x)	((StringObject*)Pointer(x))

// \\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\
// ASCII String Object /////////////////////////////////////////////
// \\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\

class ASCII_StrObject : public StringObject {
friend class EUC_StrObject;
protected:
    char    body[4];

public:
    void    Initialize (const char *string, Length len);
    void    Initialize (int nbytes, int nchars);
    void    Fill (char);

    inline int max_of_chars () const;
    Word    Element (int index);
    void    Element (int index, Word x);
    //
    void    Wait_for_set_index (const ProtocolID &, Word i, Word x);
    Word    Wait_for_elt_index (const ProtocolID &, Word i);
    Word    Wait_for_subseq_position (Word index, Word a0, Word a1);
    Word    Subseq (Word, Word);
    Word    Prepend (Word);
    //
    char    Char (Uint index) const;
    void    Char (Uint index, char);
    char   *new_C_string ();
    Name    Print ();
    Name    Print (Boolean);
};

inline int
ASCII_StrObject::max_of_chars () const
{
    return (nbytes - sizeof (StringObject)) / sizeof (char);
}

inline char
ASCII_StrObject::Char (Uint index) const
{
    return body[index];
}

inline void
ASCII_StrObject::Char (Uint index, char c)
{
    body[index] = c;
}

#define ASCII_StrObject_ptr(x)	((ASCII_StrObject*)Pointer(x))
#define IsASCII_StrObject(x)	IsBuiltinType(x,ASCII_STR)
#define sizeof_ASCII_StrObject	sizeof(StringObject)

// \\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\
// EUC String Object ///////////////////////////////////////////////
// \\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\

class EUC_StrObject : public StringObject {
friend class ASCII_StrObject;
protected:
    u_short body[2];

public:
    void    Initialize (const u_char * string, Length len);
    void    Initialize (int nbytes, int nchars);
    void    Fill (u_short);

    inline int max_of_chars () const;
    int	    index (u_short v);
    Word    Element (int index);
    void    Element (int index, Word x);
    //
    void    Wait_for_set_index (const ProtocolID &, Word i, Word x);
    Word    Wait_for_elt_index (const ProtocolID &, Word i);
    Word    Wait_for_subseq_position (Word index, Word a0, Word a1);
    Word    Subseq (Word, Word);
    Word    Prepend (Word);
    //
    char   *new_C_string ();
    Name    Print ();
    Name    Print (Boolean);
};

inline int
EUC_StrObject::max_of_chars () const
{
    return (nbytes - sizeof (StringObject)) / sizeof (u_short);
}

#define EUC_StrObject_ptr(x)	((EUC_StrObject*)Pointer(x))
#define IsEUC_StrObject(x)	IsBuiltinType(x,EUC_STR)
#define sizeof_EUC_StrObject	sizeof(StringObject)

// \\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\
// \\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\
// \\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\

extern ASCII_StrObject *new_ASCIIString (int);
extern Word CopyASCIIString (Word);
extern Word CreateASCIIString (const char *);
extern Word CreateASCIIString (int fill, int len);
extern void PrintASCIIString (Word);
extern int CompareASCIIString (Word, Word);
extern Name ASCIIStringPrintImage (Word);
extern Word ASCII2Double (ASCII_StrObject *);
extern Word ASCII2Single (ASCII_StrObject *);
extern Word ASCII2Fix (ASCII_StrObject *);

extern EUC_StrObject *new_EUCString (int);
extern Word CopyEUCString (Word);
extern Word CreateEUCString (const u_char *);
extern Word CreateEUCString (int fill, int len);
extern void PrintEUCString (Word);
extern int CompareEUCString (Word, Word);
extern Name EUCStringPrintImage (Word);
extern Word EUC2Double (EUC_StrObject *);
extern Word EUC2Single (EUC_StrObject *);
extern Word EUC2Fix (EUC_StrObject *);

extern Boolean String_quote_p;

/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-brace-offset:0
 * c-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-electric-colon:t
 * c++-empty-arglist-indent:nil
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */
#endif				/* !aum_string_h */
