/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#ifndef aum_split_h
#define aum_split_h

#include "aum/merger.h"
#include "aum/builtin.h"

inline void doSplit(Word reg)
    // {}
    // ֥ reg λȲܣ롥
    // {}
{
    if (Type_of(reg) == AUm_Object) {
	Pointer(reg)->LRC_plus(1);
    }
}

inline void doSplit(Word reg, u_short n)
    // {}
    // ֥ reg λȲܣ롥
    // {}
{
    if (Type_of(reg) == AUm_Object) {
	Pointer(reg)->LRC_plus(n);
    }
}

inline void doSplit_Object(Word reg)
    // {}
    // ֥ reg λȲܣ롥֥Ȥη
    // 祤ȤξϡλȲܣ롥
    // {}
{
    while (Type_of(reg) == AUm_Object) {
	switch (Pointer(reg)->Type()) {
	case MJ_C:
	    reg = MJ_C_ptr(reg)->Dereference();
	    continue;

	case MJ_Mut:
	    reg = MJ_Mut_ptr(reg)->Dereference();
	    continue;

	default:
	    Pointer(reg)->LRC_plus(1);
	    return;
	}
    }
}

inline void doSplit_Object(Word reg, u_short n)
    // {}
    // ֥ reg λȲܣ롥֥Ȥη
    // 祤ȤξϡλȲܣ롥
    // {}
{
    while (Type_of(reg) == AUm_Object) {
	switch (Pointer(reg)->Type()) {
	case MJ_C:
	    reg = MJ_C_ptr(reg)->Dereference();
	    continue;

	case MJ_Mut:
	    reg = MJ_Mut_ptr(reg)->Dereference();
	    continue;

	default:
	    Pointer(reg)->LRC_plus(n);
	    return;
	}
    }
}

/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-brace-offset:0
 * c-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-electric-colon:t
 * c++-empty-arglist-indent:nil
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */
#endif /* !aum_split_h */
