/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#ifndef aum_sndrcvstats_h
#define aum_sndrcvstats_h

#define SNDRCV_STATS

#ifdef SNDRCV_STATS

#include "aum/global.h"

class SndRcvStatsClass {
private:
    // {}
    // : ΥФν֤Ѥϡsndrcvstats.c ѹɬ
    // פ
    // {}
    unsigned int n_create[MAX_PE];
    unsigned int n_close[MAX_PE];
    unsigned int n_atomic[MAX_PE];
    unsigned int n_shared_args[MAX_PE];
    unsigned int n_where_are_you[MAX_PE];
    unsigned int n_iam[MAX_PE];
    unsigned int n_iam_here[MAX_PE];
    unsigned int n_copy[MAX_PE];

public:
    void atomic (u_char pe)		{ n_atomic[pe]++; }
    void shared_args (u_char pe)	{ n_shared_args[pe]++; }
    void where_are_you (u_char pe)	{ n_where_are_you[pe]++; }
    void iam_here (u_char pe)		{ n_iam_here[pe]++; }
    void iam (u_char pe)		{ n_iam[pe]++; }
    void create (u_char pe)		{ n_create[pe]++; }
    void close (u_char pe)		{ n_close[pe]++; }
    void copy (u_char pe)		{ n_copy[pe]++; }
    void where_are_you_close (u_char pe) { where_are_you(pe); close(pe); }
    void Send_to_PE0 ();
    void Report (int on_or_off_flag);
};

extern SndRcvStatsClass SndRcvStats;

#define UPDATE_SNDRCV_STATS(PE,ARGS)	{ SndRcvStats.ARGS(PE); }

#else /* not SNDRCV_STATS */

#define UPDATE_SNDRCV_STATS(ARGS)

#endif /* not SNDRCV_STATS */

/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-brace-offset:0
 * c-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-electric-colon:t
 * c++-empty-arglist-indent:nil
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */
#endif	/* !aum_sndrcvstats_h */
