/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#ifndef aum_scheduler_h
#define aum_scheduler_h

#include "config.h"
#include "aum/types.h"
#include "aum/object.h"


// ͥ٤μο
//#define MAX_PRIORITY	4
#define MAX_PRIORITY	1

class ScheduleLink {
private:
    Object*		first;
    Object*		last;

public:
    inline void		Initialize();
    //
    inline Boolean	IsEmpty();
    inline Object*	PopObject(Priority);
    inline void		PushObject(Object*);
    inline void		AppendObject(Object*);
    //
    void		Dump(int level = 0);
#ifdef PAS_DEBUGGER
    Boolean	Search_object_queue(Object* o);
    void	Dump_object_queue(int level = 0);
    Boolean	NoWhere();
#endif
};

inline void	ScheduleLink::Initialize()
    // {}
    // ͥ٤Υ֥ȥ塼롥
    // {}
{
    first = last = NULL;
}

inline Boolean	ScheduleLink::IsEmpty()
    // {}
    // 塼Τͥ٤˥֥Ȥп򤽤Ǥʤ
    // е֤
    // {}
{
    return first == 0 ? TRUE : FALSE;
}

inline Object*	ScheduleLink::PopObject(Priority p)
    // {}
    // ͥ٤Υ֥ȥ塼ƬΥ֥Ȥ곰
    // Υ֥Ȥ֤
    // {}
{
    if (IsEmpty() == TRUE)
	return NULL;
    else {
	Object* top = first;
	first = first->SchedulerNext();
	if (first == NULL)
	    Initialize();
	top->Priority(p);
	return top;
    }
}

inline void	ScheduleLink::PushObject(Object* object)
    // {}
    // ֥ȥ塼Ƭ˥֥Ȥ롥
    // {}
{
    object->SchedulerNext(first);

    if (IsEmpty() == TRUE)
	first = last = object;
    else
	first = object;
}

inline void	ScheduleLink::AppendObject(Object* object)
    // {}
    // ֥ȥ塼˥֥Ȥ롥
    // {}
{
    if (IsEmpty() == TRUE)
	first = last = object;
    else {
	last->SchedulerNext(object);
	last = object;
    }
    last->SchedulerNext(NULL);
}

class Scheduler {
private:
    Priority		active;
    Priority		max;
    ScheduleLink	queue[MAX_PRIORITY];

public:
    void		Initialize();
    //
    Object*		ActiveObject();
    void		Register(Object*);
    void		AppendObject(Object*);
    //
    inline Boolean	IsDirty();
    Boolean		PriorityControl();
    void		CurrentPriority(const Priority);
    Priority		CurrentPriority() const;
    //
    void		Dump(int indent = 0);
#ifdef PAS_DEBUGGER
    void Dump_wait_object(int level = 0);
    ScheduleLink* object_queue(int level = 0);
    Boolean NoWhere();
#endif
};

inline Boolean Scheduler::IsDirty()
    // {}
    // ߤͥ٤⤤ͥ٤Υ֥Ȥ¸ߤп򡤤
    // Ǥʤе֤
    // {}
{
    return active < max ? TRUE : FALSE;
}

inline Priority Scheduler::CurrentPriority() const
{
    return active;
}

extern Scheduler	ScheduleTable;

/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-brace-offset:0
 * c-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-electric-colon:t
 * c++-empty-arglist-indent:nil
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */
#endif /* !aum_scheduler_h */
