/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#ifndef aum_rc_h
#define aum_rc_h

#include "aum/types.h"
#include "aum/word.h"

// ///////////////////////////////////////////////////////////////

#define RC_WIDTH	(16)

class ReferenceCount {
private:
    u_short		rc;

public:
    inline		ReferenceCount();
    inline		ReferenceCount(u_short);

    inline		operator u_short () const;
    inline		operator Word () const;

    inline int		operator ++ ();
    inline int		operator -- ();

    inline void		operator += (const u_short);
    inline void		operator += (const ReferenceCount&);

    inline void		operator -= (const u_short);
    inline void		operator -= (const ReferenceCount&);

    inline int		operator == (const ReferenceCount&) const;
    inline int		operator != (const ReferenceCount&) const;
};

inline ReferenceCount::ReferenceCount() :rc(0) {}
inline ReferenceCount::ReferenceCount(u_short x) :rc(x) {}

inline ReferenceCount::operator u_short () const
{
    return rc;
}

inline ReferenceCount::operator Word () const
{
    return Word(rc);
}

inline int ReferenceCount::operator ++ ()
{
    return rc++;
}

inline int ReferenceCount::operator -- ()
{
    return --rc;
}

inline void ReferenceCount::operator += (const u_short x)
{
    rc += x;
}

inline void ReferenceCount::operator += (const ReferenceCount& x)
{
    rc += x;
}

inline void ReferenceCount::operator -= (const u_short x)
{
    rc -= x;
}

inline void ReferenceCount::operator -= (const ReferenceCount& x)
{
    rc -= x;
}

inline int ReferenceCount::operator == (const ReferenceCount& x) const
{
    return rc == x;
}

inline int ReferenceCount::operator != (const ReferenceCount& x) const
{
    return rc != x;
}


/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-brace-offset:0
 * c-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-electric-colon:t
 * c++-empty-arglist-indent:nil
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */
#endif	/* !aum_rc_h */
