/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#ifndef aum_protocolid_h
#define aum_protocolid_h

#include "aum/types.h"
#include "aum/bool.h"
#include "aum/aumtype.h"
#include "aum/word.h"

// {}
// ץȥ뼱̻
// Υץȥ뼱̻Ҥ롥
// word Υ֥ȥʣåΥƱǤ롥
//
// ʣåץȥ뼱̻
//	[ Arity(8) | Value(22) |10]
//
// ¨ͥåץȥ뼱̻
//	[   Constant(22)       |XX]:XX=00,01,11
//
// 32	   24	     16		8	2 0
//  
//  arity 	Index of Protocol Table 
//  
//
// {}
// ץȥ뼱̻ҤΥ
// Tag Width = 2bits,
// {}

// {}
// Protocol ID  Arity ʬ
// {}
#define PID_ARITY_MASK		(0xFF000000)
#define PID_ARITY_SHIFT_WIDTH	(24)

// {}
// Protocol ID  Value ʬ
// {}
#define PID_VALUE_MASK		(0x00FFFFFC)
#define PID_VALUE_SHIFT_WIDTH	(2)

// {}
// Protocol ID  Tag ʬ
// {}
#define PID_TAG_MASK		(0x3)
#define PID_TAG_SHIFT_WIDTH	(0)


typedef enum _protocoltag {
    PT_Fixnum	= AUm_Fixnum,
    PT_Atom	= AUm_Atom,
    PT_Compound = AUm_Object,
    PT_Constant = AUm_Constant,
} ProtocolTag;

class ProtocolEntry;

class ProtocolID {
private:
    ProtocolEntry*const get_ProtocolEntry() const;

protected:
    unsigned int	pid;

public:
    inline		ProtocolID();
    inline		ProtocolID(const ProtocolID&);
    inline		ProtocolID(const u_int);
    inline		ProtocolID(const u_long);
#ifdef UNION_TYPE
    inline		ProtocolID(Word);
#endif
    inline		ProtocolID(u_char, u_long, ProtocolTag);

    inline ProtocolID&	operator =  (const ProtocolID&);
    friend int		operator == (const ProtocolID&, const ProtocolID&);
    friend int		operator != (const ProtocolID&, const ProtocolID&);

    inline u_char	Type() const;
    inline int		Arity() const;
    inline u_int	Value() const;
    inline Word		asWord() const;
    inline u_int	peep() const;
    //
    Boolean		IsInlet(const int) const;
    const u_long	Mode_mask() const;
    Name const		Name() const;
    Name const		Printname() const;
};

// inline members

inline ProtocolID::ProtocolID() {}

inline ProtocolID::ProtocolID(const ProtocolID& g)
{
    pid = g.pid;
}

inline ProtocolID::ProtocolID(const u_int x)
{
    pid = x;
}

inline ProtocolID::ProtocolID(const u_long x)
{
    pid = x;
}

#ifdef UNION_TYPE
inline ProtocolID::ProtocolID(Word x)
{
    pid = x.uval;
}
#endif

inline ProtocolID::ProtocolID(u_char arity, u_long index, ProtocolTag t)
{
    pid = (  (arity << PID_ARITY_SHIFT_WIDTH)
	   + (index << PID_VALUE_SHIFT_WIDTH)
	   + (int)PT_Compound );
}

// inline functions

inline ProtocolID&  ProtocolID::operator = (const ProtocolID& g)
{
    pid = g.pid; return *this;
}

inline int /* const */ operator == (const ProtocolID& x, const ProtocolID& y)
{
    return x.pid == y.pid;
}

inline int /* const */ operator != (const ProtocolID& x, const ProtocolID& y)
{
    return x.pid != y.pid;
}

inline u_char ProtocolID::Type() const
    // {}
    // Protocol ID  Tag ʬΤߤФ
    // {}
{
    return (pid & PID_TAG_MASK) >> PID_TAG_SHIFT_WIDTH;
}

inline int ProtocolID::Arity() const
    // {}
    // Protocol ID  Arity ʬΤߤФ
    // {}
{
    if (Type() != PT_Compound)
	return 0;
    return (pid & PID_ARITY_MASK) >> PID_ARITY_SHIFT_WIDTH;
}

inline u_int ProtocolID::Value() const
    // {}
    // Protocol ID  Value ʬΤߤФ
    // {}
{
    if (Type() != PT_Compound)
	return pid;
    return (pid & PID_VALUE_MASK) >> PID_VALUE_SHIFT_WIDTH;
}

inline Word ProtocolID::asWord()
    const
{
    return (Word)pid;
}

inline u_int ProtocolID::peep() const
{
    return pid;
}

// ץȥɣĤΥ⡼ɤ +|- ɽǥХåե˽񤭹ࡥ
extern char* sprint_protocol_mode(char* buf, u_char arity, u_long modes);

extern Name	   PidPrintname(ProtocolID pid);
extern ProtocolID  InternProtocolID(Word atom, u_char arity, u_long modes);

///////////////////////////////////////////////////////////////////////////////

// {}
// 桼 PID ˤϡSTART_USER_PID β̤롥
// 0 - START_USER_PID ϥƥ PID Ǥ롥
// {}
#define START_USER_PID	16
#define userPID(_arity,_value) \
(((_arity)<<24)|(((_value)+START_USER_PID)<<2)|(int)PT_Compound)

#define userAtom(_n) (((_n << 2) | (int)PT_Atom))

// userpid.gh  awk Υץ userpid.awk Ȥäơuserpid.def
// 롥ܤϡuserpid.awk, userpid.def  Makefile 
// ȤΤ

#include "../table/userpid.gh"

/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-brace-offset:0
 * c-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-electric-colon:t
 * c++-empty-arglist-indent:nil
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */
#endif	/* !aum_protocolid_h */
