/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#ifndef aum_parallel_h
#define aum_parallel_h

class GlobalMessage;
class ClassInfo;

extern "C" {
    void	pelog();
    int		PElog;
};

///////////////////////////////////////////////////////////////////////////////
/// ޥ¸ʬۼ뤿δؿե饰  /////////////////////////////
///////////////////////////////////////////////////////////////////////////////

// ץå pe ˥å
extern void		PAS_send (unsigned char pe, GlobalMessage*);

// ¾PEåä󣰤Ȥʤ
#if defined(sequent) && !defined(SOCKET_COMM)
#define PAS_message_may_be_received (*PAS_message_may_be_received_p)
extern int*		PAS_message_may_be_received_p;
#else
extern int		PAS_message_may_be_received;
#endif

// ¾PEåɤ߹ࡥ
extern GlobalMessage*	PAS_receive ();

// ¾PEåɤ߹ࡥ(nonblocking I/O)
extern GlobalMessage*	PAS_receive_in_nonblocking ();

// PEֹ֤
extern unsigned char	PAS_next_pe ();

// ΤPEο
extern unsigned char	PAS_npe;

// ʬȤPEֹ
extern unsigned char	PAS_self_peno;

extern void	PAS_initialize_shared ();
extern void	PAS_initialize_private ();

extern int	PAS_wait_for_terminate ();

extern void	PAS_begin_monitoring ();
extern void	PAS_end_monitoring ();
extern void	PAS_report_monitoring ();

extern void	PAS_sndrcvstats_send_to_pe0 (void*, int);
extern void	PAS_report_sndrcvstats (const char*, int);

/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-brace-offset:0
 * c-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-electric-colon:t
 * c++-empty-arglist-indent:nil
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */
#endif	/* !aum_parallel_h */
