/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#ifndef aum_objecttag_h
#define aum_objecttag_h

/*
 *  Object tag.
 * Υϡ<aum/header.h> ƤإåѤ롥
 */

typedef enum _ObjectTag {
    READY	 =  0x10,	// 0001 0000
    SUSPENDED	 =  0x11,	// 0001 0001
    SLEEPING	 =  0x12,	// 0001 0010
    CLOSED	 =  0x18,	// 0001 1000
    ERROR	 =  0x19,	// 0001 1001
    SINK	 =  0x1a,	// 0001 1010

    DFLOAT	 =  0x20,	// 0010 0000
    CLASS_OBJ	 =  0x21,	// 0010 0001
    MESSAGE_OBJ	 =  0x22,	// 0010 0010
    FOREIGN_OBJ	 =  0x23,	// 0010 0011
    ASCII_STR	 =  0x24,	// 0010 0100
    EUC_STR	 =  0x25,	// 0010 0101
    VECTOR	 =  0x28,	// 0010 1000
    FILE_STREAM	 =  0x29,	// 0010 1001
    LISToo	 =  0x2c,	// 0010 1100
    LISTio	 =  0x2d,	// 0010 1101
    LISToi	 =  0x2e,	// 0010 1110
    LISTii	 =  0x2f,	// 0010 1111

    AJ_NC	 =  0x31,	// 0011 0001
//  AJ_W	 =  0x33,	// 0011 0011
    AJ_C	 =  0x34,	// 0011 0100

    MJ_NC	 =  0x39,	// 0011 1001
    MJ_W	 =  0x3b,	// 0011 1011
    MJ_C	 =  0x3c,	// 0011 1100
    MJ_Mut	 =  0x3e,	// 0011 1110

    IMP_OBJ	 =  0x41,	// 0100 0001
    IMP_OBJ_NT	 =  0x43,	// 0100 0011
    IMP_OUTLET	 =  0x48,	// 0100 0100
    IMP_INLET	 =  0x44,	// 0101 0100

    // Wait for CONNECTED
    WC_DFLOAT	   =  0x60,	// 0110 0000
    WC_CLASS_OBJ   =  0x61,	// 0110 0001
    WC_MESSAGE_OBJ =  0x62,	// 0110 0010
    WC_FOREIGN_OBJ =  0x63,	// 0110 0011
    WC_ASCII_STR   =  0x64,	// 0110 0100
    WC_EUC_STR	   =  0x65,	// 0110 0101
    WC_VECTOR	   =  0x68,	// 0110 1000
    WC_FILE_STREAM =  0x69,	// 0110 1001
    WC_LISToo	   =  0x6c,	// 0110 1100
    WC_LISTio	   =  0x6d,	// 0110 1101
    WC_LISToi	   =  0x6e,	// 0110 1110
    WC_LISTii	   =  0x6f,	// 0110 1111

    // following tag used for debugging
    UNUSED	 =  0,		// 0000 0000
    TRACE_INLET	 =  0xfe,	// 1111 1110
    GARBAGE	 =  0xff,	// 1111 1111

} ObjectTag;

#define ObjectTagMask(x,m)	(((m)&((unsigned char)(x)))==(m))

// case of MJ_C or MJ_Mut or AJ_C:
//  0x34 == 0011 0100
#define ObjectTag_connected(x)		ObjectTagMask(x,0x34)

// case of AJ_NC or MJ_NC or MJ_W
//  0x31 == 0011 0001
#define ObjectTag_not_connected(x)	ObjectTagMask(x,0x31)

// case of MJ_C or MJ_Mut:
// 0x3c == 0011 1100
#define ObjectTag_connected_merger(x)	ObjectTagMask(x,0x3c)

// case of AJ_NC, AJ_C, MJ_NC, MJ_W, MJ_C, MJ_Mut
// 0x30 == 0011 0000
#define ObjectTag_joint(x)		ObjectTagMask(x,0x30)

// case of IMP_OBJ, IMP_OBJ_NT, IMP_INLET, IMP_OUTLET
// 0x40 == 0011 0000
#define ObjectTag_imported(x)		ObjectTagMask(x,0x40)


#define CONNECTED	AJ_C: case MJ_C: case MJ_Mut
#define OBJECT		READY: case SUSPENDED: case SLEEPING: \
			case CLOSED: case ERROR: case SINK
#define BUILTIN		DFLOAT: case CLASS_OBJ: case MESSAGE_OBJ: \
			case FOREIGN_OBJ: case ASCII_STR: case EUC_STR: \
			case VECTOR: case FILE_STREAM: \
			case LISToo: case LISTio: case LISToi: case LISTii: \
			case WC_VECTOR
#define JOINT		AJ_NC: case MJ_NC: case MJ_W
#define IMPORTED_OBJECT IMP_OBJ: case IMP_OBJ_NT: case IMP_OUTLET

/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-brace-offset:0
 * c-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-electric-colon:t
 * c++-empty-arglist-indent:nil
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */
#endif	/* !aum_objecttag_h */
