/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/
// object.h

#ifndef aum_object_h
#define aum_object_h

#include <assert.h>
#include "config.h"
#include "aum/bool.h"
#include "aum/aumtype.h"
#include "aum/types.h"
#include "aum/word.h"
#include "aum/rc.h"
#include "aum/objecttag.h"
#include "aum/header.h"
#include "aum/globalid.h"
#include "aum/protocolid.h"
#include "aum/joint.h"
#include "aum/messageq.h"
#include "aum/message.h"
#include "aum/global.h"

#ifdef SNDRCV_STATS
// PE Υ֥Ȥĥå롥
extern "C" int Object_nmsgrcv;
#endif /* SNDRCV_STATS */

// {}
// ̥֥Ȥϡ桼륯饹Υ󥹥󥹤Ǥ롥
// ֥ȤμΤϥåȤθĿ饹˰ۤʤΤǡ˱
// ƲĹȤʤ롥
// ̥֥Ȥäåϡ֥ȤμꥹȤ˷
// 롥ꥹȤ˥åḁ֥̈Ȥϡ¹Բǽ
// ֤Ȥʤꡤ塼ɽϿ롥
// ֥Ȥμ֤˱ơʲΥ֥ȥѰդ
// Ƥ롥
// @item READY
// ¹⤷ϥ塼Ԥ˷Ҥä֤ɽ
// @item SUSPENDED
// ܥ饿륪֥Ȥ active ̿Ԥ֤ɽ
// @item SLEEPING
// ꥹȤξ֡ʥåԤ֡ˤɽ
// @item CLOSED
// ĺ줿֤ɽ
// @item ERROR
// Υ֥Ȥ˿˥åȡ顼Ȥʤ롥
// @item SINK
// Υ֥Ȥ˿˥åƤ⡤顼Ȥʤʤ
// {}

class ClassTmpl;

typedef class Object : public MessageQueue {
protected:
    union {
	Object*		scheduler_next;
	Priority	priority;
    };
    ClassTmpl*		classtmpl;
#ifdef PAS_DEBUGGER
    LocalMessage*	message_history;
    LocalMessage*	creater;
    int			drc;
    int			trace_mask;
    Uint		debugg_bits;
#endif /* PAS_DEBUGER */
    Word		slot[1];


public:
    void		Initialize(ClassTmpl*);
    void		Free();
    //
    void		doREADY();
    void		doSUSPENDED();
    void		doSLEEPING();
    void		doCLOSED();
    void		doSINK();
    void		doERROR();
    //
    Object*		SchedulerNext() const;
    void		SchedulerNext(Object*);
    //
    void		Scheduling();
    //
    Boolean		MessageExist() const;
    void		AppendMessage(Message*);
    void		PrependMessage(Message*);
    Message*		PopMessage();
    //
    void		Priority(Priority p);
    Priority		Priority() const;
    //
    ClassTmpl*		ClassTemplate() const;
    Name		ClassPrintname() const;
    Word		ClassName() const;
    Boolean		IsClassDefined() const;
    void		Set_slot_bases (short ibase, short obase);
    Word		Slot(u_long i) const;
    void		Slot(u_long i, Word x);
    void		InitializeInlet(u_long i);
    void		InitializeOutlet(u_long i);
    void		TerminateSlots();
    Name		InletSlotName (short) const;
    Name		OutletSlotName (short) const;
    //
    void		Connect_with_IMP_INLET(MJ_IMP_INLET_t*);
    void		Connect(J_NC_t*);
    void		Connect_and_Schedule(J_NC_t*);
    //
    Name		printStatus();
    void		Dump(int indent = 0);

    Name		Printname();
    Name		Print();
#ifdef PAS_DEBUGGER
    Word* Slot_address(u_long i);
    Boolean IsBreakObject();
    Boolean IsTraceObject();
    void SetBreakObject();
    void SetTraceObject();
    void UnSetBreakObject();
    void UnSetTraceObject();
    Boolean IsBreakObjectSlot(int pos = 0);
    Boolean IsTraceObjectSlot(int pos = 0);
    void SetBreakObjectSlot(int pos = 0);
    void SetTraceObjectSlot(int pos = 0);
    void UnSetBreakObjectSlot(int pos = 0);
    void UnSetTraceObjectSlot(int pos = 0);
    Boolean IsBreakObjectMethod(int pos = 0);
    Boolean IsTraceObjectMethod(int pos = 0);
    void SetBreakObjectMethod(int pos = 0);
    void SetTraceObjectMethod(int pos = 0);
    void UnSetBreakObjectMethod(int pos = 0);
    void UnSetTraceObjectMethod(int pos = 0);
#endif /* DEBUGER */
}*	ObjectP;

inline void	Object::doREADY()
    // {}
    // ֥Ȥ¹Բǽ֤ˤ롥
    // {}
{
    tag = READY;
}

inline void	Object::doSUSPENDED()
    // {}
    // ܥ饿륪֥Ȥ active ̿Ԥ֤ˤ롥
    // {}
{
    tag = SUSPENDED;
}

inline void	Object::doSLEEPING()
    // {}
    // ֥Ȥٻ߾֤ˤ
    // {}
{
    tag = SLEEPING;
}

inline void	Object::doCLOSED()
    // {}
    // ֥Ȥĺ֤ˤ롥
    // {}
{
    tag = CLOSED;
}

inline void	Object::doSINK()
    // {}
    // ֥Ȥ SINK ˤ롥
    // {}
{
    tag = SINK;
}

inline void	Object::doERROR()
    // {}
    // ֥Ȥ ERROR ˤ롥
    // {}
{
    tag = ERROR;
}

inline Boolean	Object::MessageExist()
    const
    // {}
    // ֥ȤåäƤ鿿ʳϵ
    // {}
{
    return Empty() ? FALSE : TRUE;
}

inline Object*	Object::SchedulerNext()
    const
    // {}
    // 塼󥯤μΥ֥Ȥ֤
    // {}
{
    return scheduler_next;
}

inline void	Object::SchedulerNext(Object* x)
    // {}
    // Υ塼󥯤˥֥Ȥꤹ롥
    // {}
{
    scheduler_next = x;
}


inline Priority Object::Priority()
    const
    // {}
    // ֥Ȥλͥ٤֤
    // {}
{
    return priority;
}

inline void	Object::Priority(Priority p)
    // {}
    // ͥ٤ꤹ롥
    // {}
{
    priority = p;
}

inline ClassTmpl* Object::ClassTemplate()
    const
    // {}
    // 󥹥󥹡֥ȤΥ饹ƥץ졼Ȥ֤
    // {}
{
    return classtmpl;
}

inline Word Object::Slot(u_long i)
    const
{
    assert (tag == READY || tag == SUSPENDED || tag == SLEEPING || tag == CLOSED);
    return slot[i];
}

inline void Object::Slot(u_long i, Word x)
{
    assert (tag == READY || tag == SUSPENDED || tag == SLEEPING || tag == CLOSED);
    slot[i] = x;
}

inline void Object::AppendMessage(Message* msg)
    // {}
    // 塼κǸ˿åɲä롥饹ȡå
    // νͤϡեȡåؤƤΤǡ
    // ǽΤΤܰʹߤΤΤȽǤɬפϤʤ
    // {}
{
    Enqueue(msg);
#ifdef SNDRCV_STATS
    Object_nmsgrcv++;
#endif
}

inline void Object::PrependMessage(Message* msg)
    // {}
    // 塼Ƭ˿å롥
    // {}
{
    Prepend(msg);
#ifdef SNDRCV_STATS
    Object_nmsgrcv++;
#endif
}

inline Message* Object::PopMessage()
    // {}
    // 塼飱åФ֤å
    // Ƥʤʤä顤last_message ᤹ͤ
    // {}
{
    return Dequeue();
}

inline Boolean
IsUserObject (const Word x)
{
    if (Type_of (x) != AUm_Object)
	return FALSE;
    switch (Pointer (x)->oTag ()) {
    case READY:
    case SUSPENDED:
    case SLEEPING:
    case CLOSED:
    case ERROR:
    case SINK:
	return TRUE;
    default:
	break;
    }
    return FALSE;
}

extern Object*	new_Object(ClassTmpl*);
extern Object*	new_InstanceObject(int index);
extern Word	CreateObject(ClassTmpl*, Priority);

/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-brace-offset:0
 * c-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-electric-colon:t
 * c++-empty-arglist-indent:nil
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */
#endif	/* !aum_object_h */
