/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#ifndef aum_msgobj_h
#define aum_msgobj_h

#include "aum/word.h"
#include "aum/sideeffect.h"
#include "aum/localmsg.h"

// Message Object ////////////////////////////////////////////////

class MessageObject : public SideEffect {
 private:
    Message * message;

 public:
    void    Initialize (Message * msg);
    Message *GetMessage () const;
    Boolean IsInlet (int) const;

    void    Wait_for_set_index (const ProtocolID &, Word i, Word x);
    Word    Wait_for_elt_index (const ProtocolID &, Word i);

    void    Free ();
    Name    Print ();
};

inline Message *
MessageObject::GetMessage () const
{
    return message;
}

#define MessageObject_ptr(x)	((MessageObject*)Pointer(x))
#define IsMessageObject(x)	IsBuiltinType(x,MESSAGE_OBJ)

extern Word new_MessageObject (Message *);
extern int CompareMessage (Word, Word);
extern void doSetArgExe (Word x, Word y, Word z, char mode);

/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-brace-offset:0
 * c-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-electric-colon:t
 * c++-empty-arglist-indent:nil
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */
#endif				/* !aum_msgobj_h */
