/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#ifndef aum_mj_nc_h
#define aum_mj_nc_h

#include "aum/j-nc.h"
#include "aum/j-c.h"
#include "aum/globalid.h"


// ///////////////////////////////////////////////////////////////
// {}
// Merger Joint Not Connected type
// {}

class Message;
class IMP_OBJ_t;

class MJ_NC_t : public J_NC_t {
private:
protected:

public:
    void		Free();
    //
    void		Send(MJ_IMP_OBJ_t*);
    void		Send(MJ_IMP_OBJ_NT_t*);
    void		Send_with_dismiss(MJ_IMP_OBJ_t*);
    void		Send_with_dismiss(MJ_IMP_OBJ_NT_t*);
    void		Connect(J_NC_t*);
    //
    inline MJ_C_t*	mut2_MJ_C(Word);
    //
    Name		Print();
    Name		Printname();
    void		Dump(int indent = 0);
};


// ///////////////////////////////////////////////////////////////
// {}
// Merger Joint Waited type
// {}
class MJ_W_t : public J_NC_t {
private:
protected:
public:
    void		Free();
    //
    MJ_C_t*		mut2_MJ_C(MJ_IMP_t*);
    MJ_IMP_t*		mut2_MJ_IMP(ObjectTag, GlobalID, int);
    //
    void		Forward_and_Close(const GlobalID& dest, u_long grc);
    void		Forward(const GlobalID& dest, u_long grc);
    void		Forward_except_first_wrus(const GlobalID& dest);
    //
    Name		Print();
};

///////////////////////////////////////////////////////////////////////////////

inline void MJ_W_t::Free()
{
    ((MJ_NC_t*)this)->Free();
}

inline MJ_C_t* MJ_NC_t::mut2_MJ_C(Word dest)
{
    ((J_C_t*)this)->Initialize(MJ_C, dest);
    return (MJ_C_t*)this;
}

#define Is_MJ_NC(x) \
((Type_of(x)==AUm_Object) && Pointer(x)->Type() == MJ_NC)

#define Is_MJ_W(x) \
((Type_of(x)==AUm_Object) && Pointer(x)->Type() == MJ_W)

/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-brace-offset:0
 * c-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-electric-colon:t
 * c++-empty-arglist-indent:nil
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */
#endif	/* !aum_mj_nc_h */
