/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#ifndef aum_mj_imp_h
#define aum_mj_imp_h

#include "aum/joint.h"
#include "aum/header.h"
#include "aum/globalid.h"
#include "aum/message.h"


// ///////////////////////////////////////////////////////////////
// {}
// ͢ɽݻޡ㥸祤
// {}

class MJ_IMP_t : public Header {
 private:
 protected:
    GlobalID gid;
    short   passed_count;
    short   import_table_index;

 public:
    void    Initialize (ObjectTag, const GlobalID &, int);
    void    Reset (const GlobalID &, int);
    //
    inline GlobalID GID () const;
    inline int Index () const;
    //
    GlobalID Split (GidHintBit);
    void    Close ();
    void    Free ();
    //
    inline MJ_W_t *mut2_MJ_W ();
    //
    Name    Print ();
};

extern MJ_IMP_t *new_MJ_IMP_t (ObjectTag, const GlobalID &, int);

inline GlobalID
MJ_IMP_t::GID () const
{
    return gid;
}

inline int
MJ_IMP_t::Index () const
{
    return import_table_index;
}

inline MJ_W_t *
MJ_IMP_t::mut2_MJ_W ()
{
    tag = MJ_W;
    ((MessageQueue *)this)->ResetMessageQueue ();
    return (MJ_W_t *) this;
}

// ///////////////////////////////////////////////////////////////
class MJ_IMP_OUTLET_t : public MJ_IMP_t {
 private:
 protected:
 public:
    MJ_W_t *Send (Message *);
    void    Connect (Header *);
    void    Connect_with_MJ_NC (MJ_NC_t *);
    void    Connect_with_AJ_NC (AJ_NC_t *);
    void    Connect_with_IMP_INLET (MJ_IMP_INLET_t *);
    MJ_W_t *Send_with_where_are_you_and_dismiss (Message *, J_NC_t *);
    void    Send_with_dismiss (Message *);
    MJ_W_t *Send_where_are_you_and_dismiss (J_NC_t *);
    void    Send_dismiss ();
};

// ///////////////////////////////////////////////////////////////
class MJ_IMP_OBJ_t : public MJ_IMP_t {
 private:
 protected:
 public:
    void    Send (Message *);
    void    Connect (Header *);
    void    Connect_with_MJ_NC (MJ_NC_t *);
    void    Connect_with_AJ_NC (AJ_NC_t *);
    void    Connect_with_IMP_INLET (MJ_IMP_INLET_t *);
    void    Answer_where_are_you (GlobalMessage *);
    void    Close_and_answer_where_are_you (GlobalMessage *);
};


// ///////////////////////////////////////////////////////////////
class MJ_IMP_OBJ_NT_t : public MJ_IMP_t {
 private:
 protected:
 public:
    inline void mut2_IMP_OBJ ();
    void    Connect (Header *);
    void    Connect_with_MJ_NC (MJ_NC_t *);
    void    Connect_with_AJ_NC (AJ_NC_t *);
    void    Connect_with_IMP_INLET (MJ_IMP_INLET_t *);
    void    Answer_where_are_you (GlobalMessage *);
    void    Close_and_answer_where_are_you (GlobalMessage *);
};

inline void
MJ_IMP_OBJ_NT_t::mut2_IMP_OBJ ()
{
    tag = IMP_OBJ;
}

// ///////////////////////////////////////////////////////////////
class MJ_IMP_INLET_t : public MJ_IMP_t {
 private:
 protected:
 public:
    void    Forward_IamHere_GRC (Header * const ptr);
    void    ExecuteMessage (Word);
    void    Return_I_am_here (const GlobalID &, u_long);
    GlobalMessage *mut2_where_are_you ();
};

/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-brace-offset:0
 * c-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-electric-colon:t
 * c++-empty-arglist-indent:nil
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */
#endif				/* !aum_mj_imp_h */
