/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#ifndef aum_messageq_h
#define aum_messageq_h

// {}
// 塼(queue)
// {}
//
//         		  
//   header  header	      ġġĢheader  
//                  
//   next      next	        NULL    
//         	        
//   last      ?????	 	        ????    
//       	        
//  	       			       
//   
//
// {}
// {}
// 饹
//
// Header  MessageLinkMessage
//	    			
//	    			MessageQueue  Object
//	    					     
//	    					      Joint
//	    
//	     Builtin Object
//
// {}

#include "aum/header.h"


class Message;
class MessageQueue;

//////////////////////////////////////////////////////////////////////////////
//////////////////////////  MessageLink	 /////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

class MessageLink : public Header {
protected:
    MessageLink*	next;

public:
    inline		MessageLink(MessageTag);
    inline		MessageLink(ObjectTag);
    inline void		Initialize(MessageTag, u_char, u_short);
    //
    Boolean		MessageExist() const;
    MessageLink*	nextMessage() const;
    void		nextMessage(MessageLink*);

    Name		PrintQueue () const;

#ifndef NDEBUG
    void		Dump () const;
#endif
};

inline MessageLink::MessageLink(MessageTag t) : /*Header*/(t) {}
inline MessageLink::MessageLink(ObjectTag t) : /*Header*/(t) {}

inline void	MessageLink::Initialize(MessageTag t, u_char a, u_short n)
{
    Header::Initialize(t, a, n);
    next = NULL;
}

inline Boolean	MessageLink::MessageExist() const
{
    return next == NULL ? FALSE : TRUE;
}

inline MessageLink*	MessageLink::nextMessage() const
{
    return next;
}

inline void		MessageLink::nextMessage(MessageLink* m)
{
    next = m;
}

///////////////////////////////////////////////////////////////////////////////
/////////////////////////////  MessageQueue  //////////////////////////////////
///////////////////////////////////////////////////////////////////////////////

class MessageQueue : public MessageLink {
protected:
    MessageLink*	last;

public:
    inline		MessageQueue(ObjectTag);
    //
    void		Initialize(ObjectTag, int RC = 0);
    inline void		ResetMessageQueue();
    //
    void		Enqueue(MessageLink*);
    Message*		Dequeue();
    inline Message*	First() const;
    inline Boolean	Empty() const;
    //
    inline Message*	Last() const;
    void		Prepend(MessageLink*);
    void		Join(MessageQueue*);
};

inline MessageQueue::MessageQueue(ObjectTag t) : (t) {}

inline void	MessageQueue::ResetMessageQueue()
{
    next = NULL;
    last = this;
}

inline void	MessageQueue::Initialize(ObjectTag t, int RC = 0)
{
    Header::Initialize(t, RC);
    ResetMessageQueue();
}

inline Message* MessageQueue::First() const
{
    return (Message*)next;
}

inline Boolean	MessageQueue::Empty() const
{
    return next == NULL ? TRUE : FALSE;
}

inline Message* MessageQueue::Last() const
{
    return (Message*)last;
}

/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-brace-offset:0
 * c-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-electric-colon:t
 * c++-empty-arglist-indent:nil
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */
#endif	/* !aum_messageq_h */
