/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#ifndef aum_message_h
#define aum_message_h

// {}
//  åեޥåȤʲ˼
//
//  tag ϡѤΥӥåȤǤꡤ餬 Msg_Local Ǥʤ
//  ϡθ 2 ղä롥2λȤϡʲ4
//  롥
//
//	+------+--------+-------+-------+
//	| tag  |	| arity |nbytes | : public Header
//	+------+--------+-------+-------+
//	| next message			| : public MessageLink
//	+-------------------------------+
//	| global ID			|
//	+----------------------------+--+
//	| protocol ID / value	     |XX| 00:int, 01:atom, 10:ext, 11: PID
//	+-------------------------------+
//	| resource		       *| : for socket communication
//	+-------------------------------+
//	| msgno			       *| : for socket communication
//	+------+--------+-------+-------+
//	| dst  | src	|	|      *| : for socket communication
//	+------+--------+-------+-------+
//	| ref.count (from messages)    *| åեޥåȤ碌뤿
//	+----------------------+-----+--+
// arg0 | index (5)	       |AA..A|10| AAAAAA: double float
//	+----------------------+-----+--+
// arg1 | value			     |00|
//	+----------------------+-----+--+
// arg2 | index (7)	       |BB..B|10| BBBBBB: string
//	+-------------------------------+
//	| WhereAreYou			|
//	+-------------------------------+
//	| Close/Create			|
//	+-------------------------------+
//    5 | double float			|
//	+-------------------------------+
//    6 |				|
//	+-------------------------------+
//    7 | string			|
//	+-------------------------------+
//    6 |				|
//	+-------------------------------+
// {}

#include "aum/messageq.h"
#include "aum/globalid.h"
#include "aum/protocolid.h"
#include "aum/word.h"

// åκΰθĿΥ⡼ɤΥӥåȥ٥Ȥ
// ɽƤ뤿ᡤʾοˤƤϤʤ
#define AUM_MAXARGS	(32)

#define MIN_MESSAGE_SIZE (sizeof(Message)-sizeof(Word))
#define MAX_MESSAGE_SIZE (sizeof(Message)+(sizeof(Word)*(-1+AUM_MAXARGS+2)))

class GlobalMessage;
class LocalMessage;
class J_NC_t;
class MJ_IMP_t;

class Message : public MessageLink {
protected:

    GlobalID		gid;
    ProtocolID		pid;

#ifdef	SOCKET_COMM
    u_long		resource;
    u_long		msgno;
    u_char		dst;
    u_char		src;
    u_char		d_1;	// dummy
    u_char		d_2;	// dummy
#endif	/* SOCKET_COMM */

    Word		argv[1];

    GlobalMessage*	Copyfrom(LocalMessage*);

public:
    inline		Message();
    inline		Message(MessageTag);
    //
    void		Initialize(MessageTag, u_char arity, u_char nbytes, const ProtocolID&);
    //
    inline MessageTag	Tag() const;
    inline void		Tag(MessageTag);
    //
    inline ProtocolID&	PID();
    inline void		PID(ProtocolID& );
    inline u_char	Arity() const;
    inline u_long	Mode_mask() const;
    inline Boolean	IsInlet (int) const;
    //
    inline GlobalID	GID() const;
    inline void		GID(const GlobalID&);

    // element extraction
    inline Word&	operator [] (int i);
    inline Word		Argv(int) const;
    inline void		Argv(int, const Word);
    // return dereferenced value
    Word		Geta(int) const;

    // mutate to Message Object
    Word		CreateMessageObject ();

    //
    void		Free();
    void		Terminate();
    void		TraceSplit();
    void		TraceClose();
    GlobalMessage*	mut2_ctl_gm(MessageTag);
    GlobalMessage*	mut2_global_message();
    GlobalMessage*	mut2_where_close(J_NC_t*, MJ_IMP_t*);

    //
    Name const		Printname() const;
    Name		PrintFunctor() const;
    Name		Print() const;
    Name		xPrint() const;
    Name		print_with_dereference(Boolean deref_or_not) const;
    Name		print_args(Boolean deref_or_not, MessageTag) const;
    Name		printLink() const;
    //
#ifdef	SOCKET_COMM
    u_long		Resource () const;
    void		Resource (u_long);
    u_long		MsgNo () const;
    void		MsgNo (u_long);
    u_short		SockSrc () const;
    void		SockSrc (u_short);
    u_short		SockDst () const;
    void		SockDst (u_short);
    void		Convert_network_byte_order ();
    void		Convert_host_byte_order ();
#endif /* SOCKET_COMM */
    void		Check_size () const;
    void		Check_tag () const;
    void		Check () const;
};

inline Message::Message() : (Msg_Private_Args) {}
inline Message::Message(MessageTag t) : (t) {}

inline MessageTag	Message::Tag() const
{
    return (MessageTag)tag;
}

inline void		Message::Tag(MessageTag t)
{
    tag = (u_char)t;
}

inline ProtocolID& Message::PID()
{
    return pid;
}

inline void Message::PID(ProtocolID& x)
{
    pid = x;
}

inline u_char	Message::Arity() const
{
    return Header::Arity();
}

inline u_long	Message::Mode_mask() const
{
    return pid.Mode_mask();
}

inline Boolean	Message::IsInlet (int n) const
{
    return pid.IsInlet (n);
}

inline GlobalID Message::GID() const
{
    return gid;
}

inline void	Message::GID(const GlobalID& g)
{
    gid = g;
}

// element extraction

inline Word&	Message::operator [] (int i)
{
    return argv[i];
}

inline Word	Message::Argv(int i) const
{
    return argv[i];
}

inline void	Message::Argv(int i, const Word x)
{
    argv[i] = x;
}

#ifdef SOCKET_COMM

inline u_long Message::Resource ()
    const
{
    return resource;
}

inline void Message::Resource (u_long r)
{
    resource = r;
}

inline u_long Message::MsgNo ()
    const
{
    return msgno;
}

inline void Message::MsgNo (u_long n)
{
    msgno = n;
}

inline u_short Message::SockSrc ()
    const
{
    return src;
}

inline void Message::SockSrc (u_short pe)
{
    src = pe;
}

inline u_short Message::SockDst ()
    const
{
    return dst;
}

inline void Message::SockDst (u_short pe)
{
    dst = pe;
}

#ifdef BIG_ENDIAN
inline void Message::Convert_network_byte_order ()
{
    /* EMPTY */
}

inline void Message::Convert_host_byte_order ()
{
    /* EMPTY */
}

#endif /* BIG_ENDIAN */

#endif /* SOCKET_COMM */

//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//
//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//
//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//

#define NILMSG		((Message*)0)

// å¤ΤƬϤ next_message СޤǤΥХȿ

#define NEXT_MESSAGE_MEMBER_OFFSET	\
((char*)&(NILMSG->next_message)-((char*)NILMSG))


//  x å¤Τ next_message ˤ뤫Τ褦˸٤
// å¤ΤβϤ֤

#define COERCE_TO_NEXT_MESSAGE(x)	\
(Message*)(((char*)(x))-NEXT_MESSAGE_MEMBER_OFFSET)

//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//
//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//
//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//

extern GlobalMessage* new_GlobalMessage(MessageTag, u_char arity, const ProtocolID&);
extern LocalMessage*  new_LocalMessage(u_char arity, const ProtocolID&);
extern LocalMessage*  new_AtomicMessage(const ProtocolID&);
extern LocalMessage*  CreateMessage(u_char arity, const ProtocolID&);
extern LocalMessage*  CreateAtomicMessage(Word atomic);
extern Message*	      CreateMessage (const ProtocolID&, Word);
extern Message*	      CreateMessage (const ProtocolID&, Word, Word);
extern Message*	      CreateMessage (const ProtocolID&, Word, Word, Word);
extern void Receive_SystemMessage (GlobalMessage*);
extern void send_to_other_pe(const GlobalID&, GlobalMessage*);

#ifdef SOCKET_COMM

extern Message*	      new_SockMessage(MessageTag, u_long);

#endif /* SOCKET_COMM */

#ifdef PAS_DEBUGGER

extern GlobalMessage* global_message_queue;

#endif /* PAS_DEBUGGER */

/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-brace-offset:0
 * c-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-electric-colon:t
 * c++-empty-arglist-indent:nil
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */
#endif	/* !aum_message_h */
