/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#ifndef aum_list_h
#define aum_list_h

#include "aum/word.h"
#include "aum/sideeffect.h"

class MessageLink;

// List Objest ///////////////////////////////////////////////////

class ListObject : public SideEffect {
 private:
    Word    car;
    Word    cdr;

    void    Initialize (ObjectTag tag, Word car, Word cdr);
 public:
    Word Car () const {
	return car;
    }
    Word    Cdr () const {
	return cdr;
    }
    void    Car (Word x) {
	car = x;
    }
    void    Cdr (Word x) {
	cdr = x;
    }
    void    Wait_for_set_index (const ProtocolID &, Word i, Word x);
    Word    Wait_for_elt_index (const ProtocolID &, Word i);
    Word    Wait_for_subseq_position (Word index, Word a0, Word a1);
    Word    Length ();
    Word    Subseq (Word, Word);
    void    Free ();
    void    Close ();
    Name    Print ();

    friend Word CopyList (Word x);
    friend Word CreateList (ObjectTag tag, Word car, Word cdr);
    friend void DeleteList (Word x);
    friend void PrintList (Word x);
    friend int CompareList (Word x, Word y);
    friend Name ListPrintImage (Word x);
};

#define ListObject_ptr(x)	((ListObject*)Pointer(x))
#define IsListoo(x)		IsBuiltinType(x,LISToo)
#define IsListio(x)		IsBuiltinType(x,LISTio)
#define IsListoi(x)		IsBuiltinType(x,LISToi)
#define IsListii(x)		IsBuiltinType(x,LISTii)

#define IsList(x) (IsListoo(x) || IsListio(x) || IsListoi(x) || IsListii(x))

extern Word doCar (Word);
extern Word doCdr (Word);
extern Word doNthList (Word x, int index);

/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-brace-offset:0
 * c-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-electric-colon:t
 * c++-empty-arglist-indent:nil
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */
#endif				/* !aum_list_h */
