/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#ifndef aum_joint_h
#define aum_joint_h

class J_C_t;
class J_NC_t;
#define J_C_ptr(x)		((J_C_t*)	     Pointer(x))
#define J_NC_ptr(x)		((J_NC_t*)	     Pointer(x))

class MJ_NC_t;
class MJ_W_t;
class MJ_C_t;
class MJ_Mut_t;
class MJ_IMP_t;
class MJ_IMP_OBJ_t;
class MJ_IMP_OBJ_NT_t;
class MJ_IMP_INLET_t;
class MJ_IMP_OUTLET_t;

#define MJ_NC_ptr(x)		((MJ_NC_t*)	     Pointer(x))
#define MJ_W_ptr(x)		((MJ_W_t*)	     Pointer(x))
#define MJ_C_ptr(x)		((MJ_C_t*)	     Pointer(x))
#define MJ_Mut_ptr(x)		((MJ_Mut_t*)	     Pointer(x))
#define MJ_IMP_ptr(x)		((MJ_IMP_t*)	     Pointer(x))
#define MJ_IMP_OBJ_ptr(x)	((MJ_IMP_OBJ_t*)     Pointer(x))
#define MJ_IMP_OBJ_NT_ptr(x)	((MJ_IMP_OBJ_NT_t*)  Pointer(x))
#define MJ_IMP_INLET_ptr(x)	((MJ_IMP_INLET_t*)   Pointer(x))
#define MJ_IMP_OUTLET_ptr(x)	((MJ_IMP_OUTLET_t*)  Pointer(x))


class AJ_NC_t;
class AJ_C_t;
#define AJ_NC_ptr(x)	((AJ_NC_t*) Pointer(x))
#define AJ_C_ptr(x)	((AJ_C_t*)  Pointer(x))

#define IsJoint(x) \
( (Type_of(x)==AUm_Object) && ObjectTag_joint(Pointer(x)->Type()) )

#define IsUndefined(x) \
( (Type_of(x)==AUm_Object) && ( ObjectTag_joint(Pointer(x)->Type()) \
			       || ObjectTag_imported(Pointer(x)->Type()) ))

#define IsImported(x) \
( (Type_of(x)==AUm_Object) && ObjectTag_imported(Pointer(x)->Type()))

extern void*	mj_alloc();
extern void	mj_free(void*);

/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-brace-offset:0
 * c-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-electric-colon:t
 * c++-empty-arglist-indent:nil
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */
#endif	/* !aum_joint_h */
