/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#ifndef aum_j_nc_h
#define aum_j_nc_h

#include "aum/messageq.h"
#include "aum/joint.h"

// {}
// Joint Not Connected
// {}

class J_NC_t : public MessageQueue {
public:
    inline		J_NC_t(ObjectTag);
    //
    inline MJ_W_t*	mut2_MJ_W();
    //
    inline Message*	PopMessage();
    inline void		AppendMessage(MessageLink*);
    inline void		PrependMessage(MessageLink*);
    void		Connect(Word);
    void		Connect(J_NC_t*);
    //
    void		Reached_atomic(Word);
    void		Reached_structure(Word);
    void		DiscardMessage(void);
};

inline J_NC_t::J_NC_t(ObjectTag t) : (t) {}

inline Message* J_NC_t::PopMessage()
{
    return Dequeue();
}

inline void	J_NC_t::AppendMessage(MessageLink* m)
{
    Enqueue(m);
}

inline void	J_NC_t::PrependMessage(MessageLink* m)
{
    Prepend(m);
}

///////////////////////////////////////////////////////////////////////////////

inline MJ_W_t* J_NC_t::mut2_MJ_W()
{
    tag = MJ_W;
    ((MessageQueue *)this)->ResetMessageQueue ();
    return (MJ_W_t*)this;
}

#define Is_J_NC(x) \
((Type_of(x)==AUm_Object) && ObjectTag_not_connected(Pointer(x)->Type()))

/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-brace-offset:0
 * c-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-electric-colon:t
 * c++-empty-arglist-indent:nil
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */
#endif	/* !aum_j_nc_h */
