/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#ifndef aum_j_c_h
#define aum_j_c_h

#include "aum/header.h"
#include "aum/joint.h"

// {}
// Joint Connected
// {}

class J_C_t : public Header {
protected:
    Word	destination;
    int		unused;

public:
    void	Initialize(ObjectTag, Word);

    Word	Destination() const;
    void	Destination(Word);
};

inline void J_C_t::Initialize(ObjectTag t, Word x)
{
    tag = t;
    destination = x;
    unused = 0;
}

inline Word J_C_t::Destination() const
{
    return destination;
}

inline void J_C_t::Destination(Word x)
{
    destination = x;
}

#define Is_J_C(x) \
((Type_of(x)==AUm_Object) && ObjectTag_connected(Pointer(x)->Type()))

extern Word  Dereference(Word);
extern Word  Dereference_with_Free(Word);

/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-brace-offset:0
 * c-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-electric-colon:t
 * c++-empty-arglist-indent:nil
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */
#endif	/* !aum_j_c_h */
