/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#ifndef aum_instantiate_h
#define aum_instantiate_h

#include "aum/mj-c.h"

extern "C" {
    void volatile abort (void);
}

extern Boolean IsInstantiated(Word& x);

inline Boolean
IsInstantiated_inline(Word& x)
    // {}
    //  x Υ֥Ȥ³Ƥ鿿򡤤Ǥʤ
    // ֤x ³줿祤Ȥξϡǥե󥹤
    // Ԥ
    // {}
{
    while (IsObject(x)) {
	switch (Pointer(x)->oTag()) {
	case MJ_C:
	    x = MJ_C_ptr(x)->Dereference ();
	    continue;

	case MJ_Mut:
	    x = MJ_Mut_ptr(x)->Dereference ();
	    continue;

	case AJ_C:
	    return IsInstantiated (J_C_ptr(x)->Destination ());

	case BUILTIN:
	    return TRUE;

	case JOINT:
	case OBJECT:
	case IMPORTED_OBJECT:
	    return FALSE;

	case IMP_INLET:
	default:
	    abort();
	}
    }
    return TRUE;
}

/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-brace-offset:0
 * c-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-electric-colon:t
 * c++-empty-arglist-indent:nil
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */
#endif	/* !aum_instantiate_h */
