/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#ifndef aum_header_h
#define aum_header_h

#include "aum/bool.h"
#include "aum/objecttag.h"
#include "aum/messagetag.h"
#include "aum/rc.h"

// {}
// Header: ֥ȤΥإå
// @picture
//	  +--------+--------+--------------------+
//	  | Tag	   |  Arity | RC or Nbytes	 | [  HEADER   ]
//	  +--------+--------+--------------------+
//	 32	  24	   16			 0
// @end
// @item Tag: ֥ȥ
//
// @item Ȳ(RC):
// Ȳ0ˤʤä顤ãǽʥ֥ȤȤƲ.
// Ȳ$2^{16}-1$ˤʤä硤Υ֥ȤϻȲˤ
// ˡǤãǽǤ뤫ɤȽǤʤʤ.  Τ褦ʥ֥
// Ȥϡ̤ˡˤ르߽ǲΤȤʹ߻Ȳ
// 䤹Ȥ⸺餹Ȥ⤷ʤ.
//
// @item Nbytes
// åΥإåȤƻȤϡå礭ɽ
// {}


// /////////////////////////////////////////////////////////////////

class Header {
protected:
    u_char		tag;
    u_char		arity;
    union {
	u_short		lrc;
	u_short		nbytes;
    } h;

public:
    inline		Header(ObjectTag);
    inline		Header(MessageTag);

    void		Initialize(ObjectTag);
    void		Initialize(ObjectTag, int RC = 0);
    void		Initialize(MessageTag);
    void		Initialize(MessageTag, u_char arity, u_short nbytes);

    MessageTag		mTag() const;
    void		mTag(MessageTag);

    ObjectTag		oTag() const;
    void		oTag(ObjectTag);
    ObjectTag		Type() const;

    ReferenceCount&	LRC();
    void		LRC_plus(int);

    u_char		Arity() const;
    u_short		no_of_bytes() const;

    Boolean		IsGarbage() const;

#ifndef NDEBUG
    void		Dump () const;
#endif
};

inline Header::Header(ObjectTag t)
{
    tag = (u_char)(t); h.lrc = 1;
};

inline Header::Header(MessageTag t)
{
    tag = (u_char)(t);
};

inline void Header::Initialize(ObjectTag t, int r)
{
    h.lrc = r;
    tag = (u_char)t;
}

inline void Header::Initialize(MessageTag t, u_char a, u_short n)
{
    tag = (u_char)t;
    arity = a;
    h.nbytes = n;
}

inline ReferenceCount&	Header::LRC()
{
    return *(ReferenceCount*)&h.lrc;
}

inline void		Header::LRC_plus(int n)
{
    h.lrc += n;
}

inline u_char		Header::Arity() const
{
    return arity;
}

inline u_short		Header::no_of_bytes() const
{
    return h.nbytes;
}

inline ObjectTag	Header::oTag() const
{
    return ObjectTag(tag);
}

inline void		Header::oTag(ObjectTag t)
{
    tag = (u_char)t;
}

inline ObjectTag	Header::Type() const
{
    return ObjectTag(tag);
}

inline MessageTag	Header::mTag() const
{
    return MessageTag(tag);
}

inline void		Header::mTag(MessageTag t)
{
    tag = (u_char)t;
}

inline Boolean		Header::IsGarbage() const
{
    return h.lrc == 0 ? TRUE : FALSE;
}

/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-brace-offset:0
 * c-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-electric-colon:t
 * c++-empty-arglist-indent:nil
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */
#endif	/* !aum_header_h */
