/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#ifndef aum_globlmsg_h
#define aum_globlmsg_h

#include "aum/message.h"
#include "table/export.h"
#include "table/import.h"

class MJ_W_t;
class MJ_IMP_t;

// {}
// PE å¤Τ
// {}

class GlobalMessage : public Message {
private:
protected:

public:
    inline GlobalID&	Reply () const;
    inline void		Reply (const GlobalID&);
    inline u_long	Dismiss () const;
    inline void		Dismiss (u_long);
    //
    inline void		set_CtlInfo(const GlobalID, const u_long);
    inline void		get_CtlInfo(GlobalID&, u_long&) const;
    inline void		geti_Iam(GlobalID&) const;
    inline void		geti_GRC(u_long&) const;
    //
    inline void		set_reply(J_NC_t*);
    inline void		set_dismiss(MJ_IMP_t*);
    inline void		set_reply_and_dismiss(J_NC_t*, MJ_IMP_t*);
    inline void		set_reply_and_value(J_NC_t*, int x);
    //
    GlobalMessage*	dissolve_ctl_message();
    GlobalMessage*	mut2_where_close(J_NC_t*, MJ_IMP_t*);
    Message*		mut2_local();
    Word		decode_word(Word);
    //
    Name		print_ctl_message();
    //
    friend GlobalMessage* new_Iam_copy (ObjectTag, void*, int);
    friend Word new_object_from_Iam_copy (const GlobalMessage *);
};

inline GlobalID&
GlobalMessage::Reply () const
    // {}
    // åѾ󣰤֤
    // {}
{
    return *(GlobalID*) &argv[Arity () + 0];
}

inline void
GlobalMessage::Reply (const GlobalID& gid)
    // {}
    // åѾ󣰤񤭹ࡥ
    // {}
{
    argv[Arity () + 0] = *(Word*)&gid;
}

inline u_long
GlobalMessage::Dismiss () const
    // {}
    // åѾ󣱤֤
    // {}
{
    return *(u_long*) &argv[Arity () + 1];
}

inline void
GlobalMessage::Dismiss (u_long grc)
    // {}
    // åѾ󣱤񤭹ࡥ
    // {}
{
    argv[Arity () + 1] = *(Word*)&grc;
}


inline void
GlobalMessage::set_CtlInfo(const GlobalID gid, const u_long grc)
    // {}
    // åѾ񤭹ࡥ
    // {}
{
    Reply (gid);
    Dismiss (grc);
}

inline void
GlobalMessage::get_CtlInfo(GlobalID& gid, u_long& grc)
    const
    // {}
    // åѾɤ߹ࡥ
    // {}
{
    gid = Reply ();
    grc = Dismiss ();
}

inline void
GlobalMessage::geti_Iam(GlobalID& iam)
    const
    // {}
    // åѾγϤɤ߹ࡥ
    // {}
{
    iam = Reply ();
}

inline void
GlobalMessage::geti_GRC(u_long& grc)
    const
    // {}
    // åѾ GRC ɤ߹ࡥ
    // {}
{
    grc = Dismiss ();
}

inline void
GlobalMessage::set_reply(J_NC_t* reply)
    // {}
    // դå where_are_you Ϥ򥻥åȤ롥
    // where_are_you Ϥ reply ͢ɽϿ̤ GID
    // Ǥ롥
    // {}
{
    Reply (ExportTable->Register((Header*)reply, 0));
}

inline void
GlobalMessage::set_dismiss(MJ_IMP_t* dismiss)
    // {}
    // դå͢ƤȲ򥻥åȤ롥
    // Ȳ dismiss ͢ɽ GRC Ǥꡤ͢
    // åΰǤ롥
    // {}
{
    Dismiss (ImportTable->Delete(dismiss));
}

inline void
GlobalMessage::set_reply_and_dismiss(J_NC_t* reply, MJ_IMP_t* dismiss)
    // {}
    // դå where_are_you Ϥ͢Ƥ
    // Ȳ򥻥åȤ롥where_are_you Ϥ reply 
    // ͢ɽϿ̤ GID Ǥ롥Ȳ dismiss ͢
    // ɽ GRC Ǥꡤ͢åΰ
    // Ǥ롥
    // {}
{
    Reply (ExportTable->Register((Header*)reply, 0));
    Dismiss (ImportTable->Delete(dismiss));
}

inline void
GlobalMessage::set_reply_and_value(J_NC_t* reply, int x)
    // {}
    // դå where_are_you Ϥ򥻥åȤ롥
    // where_are_you Ϥ reply ͢ɽϿ̤ GID
    // Ǥ롥
    // {}
{
    Reply (ExportTable->Register((Header*)reply, 0));
    Dismiss (x);
}

//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//
//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//
//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//

extern GlobalMessage* new_ctl_GlobalMessage(MessageTag);
extern GlobalMessage* new_Iam(Word atomic);
extern GlobalMessage* new_IamHere_GRC(const GlobalID&, u_long grc);
extern GlobalMessage* new_WhereAreYou(const GlobalID&);
extern GlobalMessage* new_Close(u_long);
extern void	      Answer_where_are_you (GlobalMessage*, Header*);
extern void	      Answer_where_are_you (GlobalMessage*, Word);
extern void	      ExecuteGlobalMessage (Word dest, GlobalMessage*);

extern GlobalMessage* new_Iam_copy (ObjectTag, void*, int);

/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-brace-offset:0
 * c-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-electric-colon:t
 * c++-empty-arglist-indent:nil
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */
#endif	/* !aum_globlmsg_h */
