/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#ifndef aum_globalid_h
#define aum_globalid_h

#include <sys/types.h>
#include "aum/word.h"

#ifndef NDEBUG
extern "C" {
    void volatile	abort(void);
}
#endif

// {}
// Global ID 
// @picture
//	  +----------------+--------+---+----+---+
//	  |	Index	   |  #PE   |WRC|Hint|Tag|
//	  +----------------+--------+---+----+---+
//	 32		  16	    8	4    2	 0
// @end
// @item Index: PE ͢ɽ(ƬΥեå)
//
// @item #PE:	PE ֹ
//
// @item WRC:	ŤդȲ
// @item Hint:	ҥȥӥåȡ͢Фηɽ
// @picture
//		00: ̥֥(OBJECT)
//		01: üʻ祸祤Ȥνü(OUTLET)
//		10: üʻ祸祤Ȥü(MJ_INLET)
//		11: <̤>
// @end
// @item Tag :	 10 ͤ롥
// {}

// {}
// Global ID Υ
// {}
#define GID_TAG_SHIFT_WIDTH	(0)
#define GID_TAG_MASK		(0x3)

// {}
// Global ID Υҥ
// {}
#define GID_HINT_SHIFT_WIDTH	(2)
#define GID_HINT_MASK		(0xc)


// #define BIG_WEIGHT
#ifdef BIG_WEIGHT

// 2^15 = 32768
#define WEIGHT			(15)

#else /* not BIG_WEIGHT */

// 2^7	= 128
// 2^3	= 8
#define WEIGHT			(3)

#endif /* not BIG_WIDTH */

// {}
// Global ID νŤդȲȥӥåȥޥ
// {}
#define GID_WRC_SHIFT_WIDTH	(4)
#define GID_WRC_MASK		(WEIGHT << GID_WRC_SHIFT_WIDTH)

// IamHere ȰŤդȲ͡
#define WEIGHT_of_IamHere	(1<<WEIGHT)


// {}
// Global ID  PE ȥӥåȥޥ
// {}
#define GID_PE_SHIFT_WIDTH	(8)
#define GID_PE_MASK		(0x0000FF00)

// {}
// Global ID  Index ȥӥåȥޥ
// {}
#define GID_INDEX_SHIFT_WIDTH	(16)
#define GID_INDEX_MASK		(0xFFFF0000)

// {}
// Global ID  Index  PE Υӥåȥޥ
// {}
#define GID_ADDRESS_MASK	(GID_INDEX_MASK|GID_PE_MASK)


// {}
// Global ID Υ:ɤΥͤƱݥ󥿤˴ؤ
// ̾Ȥʤ롥
// {}
typedef enum gid_tag {
    GID_Atom		= AUm_Atom,
    GID_Fixnum		= AUm_Fixnum,
    GID_Pointer		= AUm_Object,
    GID_Constant	= AUm_Constant,
} GidTag;

// {}
// Global ID Υҥȥӥåȡۥ륪֥ȤΥ⡼(in/out)
// ӥ祤ȤΥ˱ưʲͤȤ롥
// {}
typedef enum gid_hint_bit {
    GID_HINT_OBJECT	= (0<<GID_HINT_SHIFT_WIDTH),
    GID_HINT_OUTLET	= (1<<GID_HINT_SHIFT_WIDTH),
    GID_HINT_MJ_INLET	= (2<<GID_HINT_SHIFT_WIDTH),
} GidHintBit;

class GlobalID {
private:
    unsigned int gid;

public:

    inline		GlobalID();
    inline		GlobalID(const GlobalID&);
    inline		GlobalID(const u_int);
    inline		GlobalID(const u_long);
    inline		GlobalID(u_int index, u_char pe, u_char weight);
			GlobalID(Word, GidHintBit, u_char w = 0);

    inline operator	Word() const;

    inline GlobalID&	operator =  (const GlobalID&);
    friend int		operator == (const GlobalID&, const GlobalID&);
    friend int		operator != (const GlobalID&, const GlobalID&);

    inline u_int	Index() const;
    inline u_int	PE() const;

    inline u_int	WRC() const;
    inline void		WRC(u_char);
    inline GidHintBit	Hint() const;
    inline void		Hint(GidHintBit);

    inline GidTag	Tag() const;
    inline u_int	Address() const;
    inline u_int	Hashval() const;
    inline u_int	ReferenceCount() const;
    //
    GlobalID		Tagging(GidHintBit, u_long w = 0);
    Name		Print() const;
    inline u_int	peep () const;
};

// inline members
inline GlobalID::GlobalID() {}

inline GlobalID::GlobalID(const GlobalID& g)
{
    gid = g.gid;
}

inline GlobalID::GlobalID(const u_int x)
{
    gid = x;
}

inline GlobalID::GlobalID(const u_long x)
{
    gid = x;
}

inline GlobalID::GlobalID(u_int index, u_char pe, u_char weight)
{
#ifndef NDEBUG
    if ((weight & ~(GID_WRC_MASK >> GID_WRC_SHIFT_WIDTH)) != 0) abort();
#endif
    gid = (index << GID_INDEX_SHIFT_WIDTH) | (pe<<GID_PE_SHIFT_WIDTH)
	| (weight << GID_WRC_SHIFT_WIDTH) | (int)GID_Pointer;
}

inline GlobalID::operator Word() const
{
    return Word(gid);
}

// inline functions

inline GlobalID&  GlobalID::operator = (const GlobalID& g)
{
    gid = g.gid; return *this;
}

inline int operator == (const GlobalID& x, const GlobalID& y)
{
    return x.gid == y.gid;
}

inline int operator != (const GlobalID& x, const GlobalID& y)
{
    return x.gid != y.gid;
}

// ///////////////////////////////////////////////////////////////

inline u_int GlobalID::Index() const
    // {}
    // GID ˥󥳡ɤƤ͢и͢ɽ⥪եåͤ
    // 
    // {}
{
    struct gidindex {
#ifdef BIG_ENDIAN
	u_short s1, s2;
#else
	u_short s2, s1;
#endif
    };
    return ((struct gidindex *)&gid)->s1;
    /* return (gid & GID_INDEX_MASK) >> GID_INDEX_SHIFT_WIDTH; */
}

inline u_int GlobalID::PE() const
    // {}
    // GID ˥󥳡ɤƤ͢иPEֹФ
    // {}
{
    struct gidpe {
#ifdef BIG_ENDIAN
	u_char b1, b2, b3, b4;
#else
	u_char b4, b3, b2, b1;
#endif
    };
    return ((struct gidpe *)&gid)->b3;
    /* return (gid & GID_PE_MASK) >> GID_PE_SHIFT_WIDTH; */
}

inline u_int GlobalID::WRC() const
    // {}
    // GID νŤդȲ֤ͤ
    // {}
{
    return gid & GID_WRC_MASK;
}

inline void GlobalID::WRC(u_char wrc)
    // {}
    // GID νŤդȲ wrc ˤ롥
    // {}
{
    gid = (gid & ~GID_WRC_MASK) | (wrc << GID_WRC_SHIFT_WIDTH);
}

inline GidHintBit GlobalID::Hint() const
    // {}
    // GID ΥҥȥӥåȤ֤
    // {}
{
    return (GidHintBit)(gid & GID_HINT_MASK);
}

inline void GlobalID::Hint(GidHintBit hint)
    // {}
    // GID ΥҥȥӥåȤ hint ˤ롥
    // {}
{
    gid = (gid & ~GID_HINT_MASK) | (int)hint;
}

inline GidTag GlobalID::Tag() const
    // {}
    // GID Υ֤ͤ
    // {}
{
    return (GidTag)(gid & GID_TAG_MASK);
}

inline u_int GlobalID::Address() const
    // {}
    // GID  Index  PE ʬΤߤФ
    // {}
{
    return gid & GID_ADDRESS_MASK;
}

inline u_int GlobalID::Hashval() const
    // {}
    // GID ֤ͤ
    // {}
{
    return gid & (GID_ADDRESS_MASK|GID_HINT_MASK|GID_TAG_MASK);
}

inline u_int GlobalID::ReferenceCount() const
    // {}
    // GID νŤդȲ̾λȲͤȤ֤
    // ŤդȲϣλؿͤȤͿ롥
    // @example
    // gid.WRC |    RC
    //	  0    |  1 (2^0)
    //	  1    |  2 (2^1)
    //	  2    |  4 (2^2)
    //	  3    |  8 (2^3)
    //	  4    | 16 (2^4)
    //	  5    | 32 (2^5)
    //	  .........
    // @end
    // {}
{
    // 2^WRC;
    return 1 << ( WRC() >>  GID_WRC_SHIFT_WIDTH );
}

inline u_int GlobalID::peep() const
{
    return gid;
}

/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-brace-offset:0
 * c-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-electric-colon:t
 * c++-empty-arglist-indent:nil
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */
#endif	/* !aum_global_h */
