/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#ifndef aum_global_h
#define aum_global_h

#include "aum/word.h"
#include "aum/bool.h"
#include "aum/strategy.h"

// //////////////////////////////////////////////////////////////////////

#ifdef GLOBAL_VARIABLE

#define Extern
#define Init(x)		= x
#define Size(size)	size

#else				/* not GLOBAL_VARIABLE */

#define Extern		extern
#define Init(x)
#define Size(size)

#endif				/* not GLOBAL_VARIABLE */

// //////////////////////////////////////////////////////////////////////

#define MAX_PE		(16)
#define MAX_REG		(64)

Extern Word NILATOM;
Extern Word PLUS_ATOM;
Extern Word MINUS_ATOM;
Extern Word ASTERISK_ATOM;
Extern Word SLASH_ATOM;
Extern Word INSTANTIATED_ATOM;
Extern Word AUM_ATOM;

Extern Word Reg[Size (MAX_REG)];
Extern int ExitStatus;
Extern u_long Warnning;

Extern const char *Program_filename;
Extern const char *Programname;
Extern int Argc;
Extern int PasArgc;
Extern const char **Argv;
Extern const char **PasArgv;
Extern const char *Logfile;

Extern int TimeSlice;
Extern Boolean TraceMessage Init (FALSE);
Extern Boolean TraceInstruction Init (FALSE);
Extern Boolean Verbose Init (FALSE);
Extern Boolean ShowRC Init (FALSE);
Extern Boolean NameList_load_p Init (FALSE);
Extern Boolean Statistics_flag Init (FALSE);

// optionally atom table size
Extern int Tatom Init (0);

// optionally protocol-id table size
Extern int Tprotocol Init (0);

// optionally export table size
Extern int Texport Init (0);

// optionally import table size
Extern int Timport Init (0);

// scheduling strategy
Extern Strategy Scheduling_strategy;

// debugging switch
Extern Boolean DebugConnect Init (FALSE);

// create object in other PE
Extern Boolean Always_external_creation Init (FALSE);
Extern Boolean Even_external_creation Init (FALSE);
Extern Boolean Odd_external_creation Init (FALSE);

class Object;
class	Message;
class	ClassTmpl;

Extern Object *CurrentObject;
Extern Message *CurrentMessage;
Extern const ClassTmpl *CurrentClass;

Extern Word *InletSlotBase;
Extern Word *OutletSlotBase;

Extern Word InitInletSlot;
Extern Word InitOutletSlot;

Extern Word ClassNameInteger;
Extern Word ClassNameSFloat;
Extern Word ClassNameAtom;
Extern Word ClassNameBool;
Extern Word ClassNameList;
Extern Word ClassNameString;
Extern Word ClassNameVector;
Extern Word ClassNameDFloat;
Extern Word ClassNameClass;
Extern Word ClassNameMessage;
Extern Word ClassNameForeign;
Extern Word ClassNameFileStream;

/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-brace-offset:0
 * c-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-electric-colon:t
 * c++-empty-arglist-indent:nil
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */
#endif				/* !aum_global_h */
