/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/


#ifndef aum_fstream_h
#define aum_fstream_h

#include <stdio.h>
#include <stream.h>
#include "aum/header.h"
#include "aum/alloc.h"
#include "aum/word.h"

extern Name print(Word x);

class FileStreamObject : public Header
{
    u_short nchars,nbytes;
    Boolean is_native;
    FILE* fp;
    char mode[4];
    const char* name;
    int Copyfrom(FileStreamObject* g);
  public:
    void TextMode(Boolean t);
    Boolean TextMode();
    long Fseek(int size, int pos);
    void Free();
    Name Print();
    void Initialize(const char* x,const char* y,FILE* f);
    friend FileStreamObject* new_FileStream(const char* f,const char* m,FILE* p);
    Word Get();
    int no_of_bytes();
    int no_of_chars();
    void Tab(const int x);
    void Putc(Word& y);
    void Puts(const char* x);
    char* GetCstring();
    Word Gets();
    Word Getc();
    Word Iseof();
    void Ungetc(const u_short x);
    void Flush();
    void Put(Word& x);
    void Fclose();
};

#define IsFStream(x) (IsBuiltinType((x),FILE_STREAM))
#define FileStreamObject_ptr(x) ((FileStreamObject*)Pointer(x))

/*-----------------
* Local Variables:
* c-argdecl-indent:4
* c-indent-level:4
* c-label-offset:-2
* c-continued-statement-offset:4
* End:
*/
#endif	/* !aum_fstream_h */
