/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#ifndef aum_fetch_h
#define aum_fetch_h

#include "config.h"
#include "aum/word.h"
#include "aum/global.h"
#include "aum/code.h"
#include "aum/protocolid.h"
#include "aum/trace.h"

#ifdef BIG_ENDIAN
#define operand_byte4		unsigned char b0, b1, b2, b3;
#define operand_short2		short s0, s1;
#define operand_byte2_short1	unsigned char b0, b1; short s0;
#define operand_byte2_short3	unsigned char b0, b1; short s0; short s1, s2;
#define operand_if_then_else	unsigned char ri, rj; short l_true; \
						      short l_false, z;
#else /* not BIG_ENDIAN */
#define operand_byte4		unsigned char b3, b2, b1, b0;
#define operand_short2		short s1, s0;
#define operand_byte2_short1	short s0; unsigned char b1, b0;
#define operand_byte2_short3	short s0; unsigned char b1, b0; short s2, s1;
#define operand_if_then_else	short l_true; unsigned char rj, ri; \
				short z, l_false;
#endif /* not BIG_ENDIAN */

class Object;
class Message;
class ClassTmpl;

extern void		SetMessageArgs(Message* mp, u_char arity);


#ifdef ENABLE_INSTRUCTION_TRACE

#define DO_TRACE_INSTRUCTION \
do{if (TraceInstruction == TRUE) PrintInstruction(InstructionPointer);}while(0)

#ifdef PAS_DEBUGGER
#include "aum/object.h"
#include "aum/debugger.h"

#define DO_TRACE_INSTRUCTION_FOR_DEBUGGER \
do{if((trace_switch == TRUE)||(TraceInstruction == TRUE))PrintInstruction(InstructionPointer);}while(0)
#endif

#else

#ifdef PAS_DEBUGGER
#include "aum/object.h"
#include "aum/debugger.h"

#define DO_TRACE_INSTRUCTION_FOR_DEBUGGER \
do{if((trace_switch == TRUE)||(TraceInstruction == TRUE))PrintInstruction(InstructionPointer);}while(0)
#else

#define DO_TRACE_INSTRUCTION

#endif
#endif

////////////////////////////////////////////////////////////////////////////
///////////////////////	 JumpNextInstruction  //////////////////////////////
////////////////////////////////////////////////////////////////////////////

#if defined(NDEBUG) && defined(i386) & defined(sequent)

#define JUMPNEXT			      \
do {					      \
	asm("leave");			      \
	asm("movl _InstructionPointer,%eax"); \
	asm("jmp *(%eax)");		      \
return;}while(0)

#define PushRegisters()	  \
	asm("pushl %edi");\
	asm("pushl %esi");\
	asm("pushl %edx");\
	asm("pushl %ecx");\
	asm("pushl %ebx");

#define PopRegisters()	 \
	asm("popl %ebx");\
	asm("popl %ecx");\
	asm("popl %edx");\
	asm("popl %esi");\
	asm("popl %edi");

#else /* not NDEBUG */

#define JUMPNEXT (Function(*InstructionPointer))();

#define PushRegisters()
#define PopRegisters()

#endif /* not NDEBUG */

#ifdef PAS_DEBUGGER
extern debugger_symbol db_cont;
extern Boolean trace_switch;
extern Boolean stop;
extern Boolean step;
extern Boolean break_method;
extern Boolean next_step;
extern debugger_symbol BreakLoop(Boolean* t,Object* o);
extern void print_register(const Instruction* oa,Boolean t = FALSE);

#define BREAK_LOOP    if (stop) { \
			stop = FALSE; \
			 db_cont = BreakLoop(&trace_switch,CurrentObject); \
			    if (db_cont == QUIT) \
				return ; \
			    if (db_cont == STEP){\
				trace_switch = FALSE; \
				step = TRUE;  }\
			    if (db_cont == NEXTSTEP){ \
				step = TRUE; \
				next_step = TRUE; }\
			    if (db_cont == STEPINST){ \
				step = TRUE; \
				trace_switch = TRUE; }\
			    if (db_cont == CONTINUE){ \
				trace_switch = FALSE; \
				break_method = FALSE; \
				step = FALSE; \
			    } \
		  } \

#define JumpNext() \
do {\
	if (break_method||(step && trace_switch)){\
	      stop = TRUE;\
	}\
	DO_TRACE_INSTRUCTION_FOR_DEBUGGER;  \
	BREAK_LOOP;\
	if (db_cont == QUIT) return;\
	JUMPNEXT; return; } while (0)

#define JumpNextInstruction() \
do {\
	if (trace_switch)print_register(InstructionPointer); \
	InstructionPointer += sizeof(*ip) / sizeof(Instruction); \
	if (break_method||(step && trace_switch)){\
	      stop = TRUE;\
	}\
	DO_TRACE_INSTRUCTION_FOR_DEBUGGER;  \
	BREAK_LOOP;\
	if (db_cont == QUIT) return;\
	JUMPNEXT; return; } while (0)
#else
#define JumpNextInstruction() \
do {\
	InstructionPointer += sizeof(*ip) / sizeof(Instruction); \
	DO_TRACE_INSTRUCTION;					 \
	JUMPNEXT; return; } while (0)
#endif

////////////////////////////////////////////////////////////////////////////
///////////////////////	 CallNextInstruction  //////////////////////////////
////////////////////////////////////////////////////////////////////////////

#ifdef PAS_DEBUGGER
inline void CallNextInstruction() {
    if (break_method||(step && trace_switch)){
	trace_switch = TRUE;
	stop = TRUE;
    }
    if (trace_switch)print_register(InstructionPointer);
    DO_TRACE_INSTRUCTION_FOR_DEBUGGER;
    BREAK_LOOP;
    if (db_cont == QUIT) return;
    (Function(*InstructionPointer))();
}
#else
inline void CallNextInstruction() {
    DO_TRACE_INSTRUCTION;
    (Function(*InstructionPointer))();
}
#endif

//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\
//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\
//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\

#define PAS_Fetch_(TYPE) \
const TYPE *const ip = (const TYPE *const)InstructionPointer

// {}
// Fetch112()
// {}
// [  (*funcp) ()      ]
// [  Ri|  Rj|	     Vn]
// {}
struct b2s1 {
    Instruction func;
    operand_byte2_short1;
};
#define Fetch112()	PAS_Fetch_(struct b2s1)

// {}
// Fetch12pid()
// {}
// [  (*funcp) ()      ]
// [  Ri|   0|	     Vn]
// [		     Vp]
// {}
struct b1s1pid {
    Instruction func;
    operand_byte2_short1;
    ProtocolID vp;
};
#define Fetch12pid()	PAS_Fetch_(struct b1s1pid)

// {}
// Fetch1val()
// {}
// [  (*funcp) ()      ]
// [  Ri|   0|	      0]
// [		     Vi]
// {}
struct b1val {
    Instruction func;
    operand_byte4;
    Word wval;
};
#define Fetch1val()	PAS_Fetch_(struct b1val)

// {}
// void Fetch4()
// {}
// [  (*funcp) ()      ]
// [  Ri|  Rj|	Rk|   0]
// {}
struct b4 {
    Instruction func;
    operand_byte4;
};
#define Fetch4()	PAS_Fetch_(struct b4)

// {}
// Fetch2short3()
// {}
// [  (*funcp) ()      ]
// [  Ri|  Rj|	     S0]
// [	   S1|	     S2]
// {}
struct b2s3 {
    Instruction func;
    operand_byte2_short3;
};
#define Fetch2short3()	PAS_Fetch_(struct b2s3)

// {}
// Fetch22()
// {}
// [  (*funcp) ()      ]
// [	   S0|	     S1]
// {}
struct s2 {
    Instruction func;
    operand_short2;
};
#define Fetch22()	PAS_Fetch_(struct s2)

// {}
// Fetch_IF()
// {}
// [  (*funcp) ()      ]
// [  Ri|  Rj|	 L_true]
// [  L_false|	      0]
// {}
struct if_then_else {
    Instruction func;
    operand_if_then_else;
};
typedef struct if_then_else If_then_else;

// {}
// RegNumber* FetchSkip(n)
// {}
// {}
inline RegNumber* FetchSkip(int n)
{
    RegNumber* top = (RegNumber*)InstructionPointer;
    InstructionPointer += n;
    return top;
}

inline void* Indirection(u_short x)
{
    int** p = (int**)(InstructionPointer + x);
    return (void*)(*p);
}


//////////////////////////////////////////////////////////////////////////////
///////////////////////	 METHOD(name, type)  /////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

#define METHOD(name,type) void aum_##name()

/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-brace-offset:0
 * c-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-electric-colon:t
 * c++-empty-arglist-indent:nil
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */
#endif	/* !aum_fetch_h */
